/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.core.types.RedisClientInfo;

@NullUnmarked
public interface RedisServerCommands {
    public void bgReWriteAof();

    public void bgSave();

    public Long lastSave();

    public void save();

    public Long dbSize();

    public void flushDb();

    public void flushDb(@NonNull FlushOption var1);

    public void flushAll();

    public void flushAll(@NonNull FlushOption var1);

    public Properties info();

    public Properties info(@NonNull String var1);

    public void shutdown();

    public void shutdown(@Nullable ShutdownOption var1);

    public Properties getConfig(@NonNull String var1);

    public void setConfig(@NonNull String var1, @NonNull String var2);

    public void resetConfigStats();

    public void rewriteConfig();

    default public Long time() {
        return this.time(TimeUnit.MILLISECONDS);
    }

    public Long time(@NonNull TimeUnit var1);

    public void killClient(@NonNull String var1, int var2);

    public void setClientName(byte @NonNull [] var1);

    public String getClientName();

    public List<@NonNull RedisClientInfo> getClientList();

    public void replicaOf(@NonNull String var1, int var2);

    public void replicaOfNoOne();

    public void migrate(byte @NonNull [] var1, @NonNull RedisNode var2, int var3, @Nullable MigrateOption var4);

    public void migrate(byte @NonNull [] var1, @NonNull RedisNode var2, int var3, @Nullable MigrateOption var4, long var5);

    public static enum FlushOption {
        SYNC,
        ASYNC;

    }

    public static enum MigrateOption {
        COPY,
        REPLACE;

    }

    public static enum ShutdownOption {
        SAVE,
        NOSAVE;

    }
}

