/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Properties;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisServer
extends RedisNode {
    private Properties properties;

    public RedisServer(String host, int port) {
        this(host, port, new Properties());
    }

    public RedisServer(String host, int port, @Nullable Properties properties) {
        super(host, port);
        this.properties = properties != null ? properties : new Properties();
        Object name = host + ":" + port;
        if (properties != null && properties.containsKey(INFO.NAME.key)) {
            name = this.get(INFO.NAME);
        }
        this.setName((String)name);
    }

    public static RedisServer newServerFrom(Properties properties) {
        String host = properties.getProperty(INFO.HOST.key, "127.0.0.1");
        int port = Integer.parseInt(properties.getProperty(INFO.PORT.key, "26379"));
        return new RedisServer(host, port, properties);
    }

    public void setQuorum(@Nullable Long quorum) {
        if (quorum == null) {
            this.properties.remove(INFO.QUORUM.key);
            return;
        }
        this.properties.put(INFO.QUORUM.key, quorum.toString());
    }

    public @Nullable String getRunId() {
        return this.get(INFO.RUN_ID);
    }

    public @Nullable String getFlags() {
        return this.get(INFO.FLAGS);
    }

    @Override
    public boolean isMaster() {
        String role = this.getRoleReported();
        if (!StringUtils.hasText((String)role)) {
            return false;
        }
        return role.equalsIgnoreCase("master");
    }

    public @Nullable Long getPendingCommands() {
        return this.getLongValueOf(INFO.PENDING_COMMANDS);
    }

    public @Nullable Long getLastPingSent() {
        return this.getLongValueOf(INFO.LAST_PING_SENT);
    }

    public @Nullable Long getLastOkPingReply() {
        return this.getLongValueOf(INFO.LAST_OK_PING_REPLY);
    }

    public @Nullable Long getDownAfterMilliseconds() {
        return this.getLongValueOf(INFO.DOWN_AFTER_MILLISECONDS);
    }

    public @Nullable Long getInfoRefresh() {
        return this.getLongValueOf(INFO.INFO_REFRESH);
    }

    public @Nullable String getRoleReported() {
        return this.get(INFO.ROLE_REPORTED);
    }

    public @Nullable Long roleReportedTime() {
        return this.getLongValueOf(INFO.ROLE_REPORTED_TIME);
    }

    public @Nullable Long getConfigEpoch() {
        return this.getLongValueOf(INFO.CONFIG_EPOCH);
    }

    public @Nullable Long getNumberReplicas() {
        return this.getLongValueOf(INFO.NUMBER_SLAVES);
    }

    public @Nullable Long getNumberOtherSentinels() {
        return this.getLongValueOf(INFO.NUMBER_OTHER_SENTINELS);
    }

    public @Nullable Long getQuorum() {
        return this.getLongValueOf(INFO.QUORUM);
    }

    public @Nullable Long getFailoverTimeout() {
        return this.getLongValueOf(INFO.FAILOVER_TIMEOUT);
    }

    public @Nullable Long getParallelSyncs() {
        return this.getLongValueOf(INFO.PARALLEL_SYNCS);
    }

    public @Nullable String get(INFO info) {
        Assert.notNull((Object)((Object)info), (String)"Cannot retrieve client information for 'null'");
        return this.get(info.key);
    }

    public @Nullable String get(String key) {
        Assert.hasText((String)key, (String)"Cannot get information for 'empty' / 'null' key.");
        return this.properties.getProperty(key);
    }

    private @Nullable Long getLongValueOf(INFO info) {
        String value = this.get(info);
        return value == null ? null : Long.valueOf(value);
    }

    public static enum INFO {
        NAME("name"),
        HOST("ip"),
        PORT("port"),
        RUN_ID("runid"),
        FLAGS("flags"),
        PENDING_COMMANDS("pending-commands"),
        LAST_PING_SENT("last-ping-sent"),
        LAST_OK_PING_REPLY("last-ok-ping-reply"),
        DOWN_AFTER_MILLISECONDS("down-after-milliseconds"),
        INFO_REFRESH("info-refresh"),
        ROLE_REPORTED("role-reported"),
        ROLE_REPORTED_TIME("role-reported-time"),
        CONFIG_EPOCH("config-epoch"),
        NUMBER_SLAVES("num-slaves"),
        NUMBER_OTHER_SENTINELS("num-other-sentinels"),
        BUFFER_LENGTH("qbuf"),
        BUFFER_FREE_SPACE("qbuf-free"),
        OUTPUT_BUFFER_LENGTH("obl"),
        OUTPUT_LIST_LENGTH("number-other-sentinels"),
        QUORUM("quorum"),
        FAILOVER_TIMEOUT("failover-timeout"),
        PARALLEL_SYNCS("parallel-syncs");

        String key;

        private INFO(String key) {
            this.key = key;
        }
    }
}

