/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;

public class StreamInfo {

    public static class XInfoConsumer
    extends XInfoObject {
        private final String groupName;

        public XInfoConsumer(String groupName, List<Object> raw) {
            super(raw, DEFAULT_TYPE_HINTS);
            this.groupName = groupName;
        }

        public String groupName() {
            return this.groupName;
        }

        public String consumerName() {
            return this.getRequired("name", String.class);
        }

        public long idleTimeMs() {
            return this.getRequired("idle", Long.class);
        }

        public Duration idleTime() {
            return Duration.ofMillis(this.idleTimeMs());
        }

        public long pendingCount() {
            return this.getRequired("pending", Long.class);
        }
    }

    public static class XInfoConsumers
    implements Streamable<XInfoConsumer> {
        private final List<XInfoConsumer> consumerInfoList = new ArrayList<XInfoConsumer>();

        public XInfoConsumers(String groupName, List<Object> raw) {
            for (Object entry : raw) {
                this.consumerInfoList.add(new XInfoConsumer(groupName, (List)entry));
            }
        }

        public static XInfoConsumers fromList(String groupName, List<Object> source) {
            return new XInfoConsumers(groupName, source);
        }

        public int getConsumerCount() {
            return this.consumerInfoList.size();
        }

        public int size() {
            return this.consumerInfoList.size();
        }

        public boolean isEmpty() {
            return this.consumerInfoList.isEmpty();
        }

        public Iterator<XInfoConsumer> iterator() {
            return this.consumerInfoList.iterator();
        }

        public XInfoConsumer get(int index) {
            return this.consumerInfoList.get(index);
        }

        public Stream<XInfoConsumer> stream() {
            return this.consumerInfoList.stream();
        }

        public void forEach(Consumer<? super XInfoConsumer> action) {
            this.consumerInfoList.forEach(action);
        }

        public String toString() {
            return "XInfoConsumers" + String.valueOf(this.consumerInfoList);
        }
    }

    public static class XInfoGroup
    extends XInfoObject {
        private XInfoGroup(List<Object> raw) {
            super(raw, DEFAULT_TYPE_HINTS);
        }

        public static XInfoGroup fromList(List<Object> raw) {
            return new XInfoGroup(raw);
        }

        public String groupName() {
            return this.getRequired("name", String.class);
        }

        public Long consumerCount() {
            return this.getRequired("consumers", Long.class);
        }

        public Long pendingCount() {
            return this.getRequired("pending", Long.class);
        }

        public String lastDeliveredId() {
            return this.getRequired("last-delivered-id", String.class);
        }
    }

    public static class XInfoGroups
    implements Streamable<XInfoGroup> {
        private final List<XInfoGroup> groupInfoList = new ArrayList<XInfoGroup>();

        private XInfoGroups(List<Object> raw) {
            for (Object entry : raw) {
                this.groupInfoList.add(new XInfoGroup((List)entry));
            }
        }

        public static XInfoGroups fromList(List<Object> source) {
            return new XInfoGroups(source);
        }

        public int groupCount() {
            return this.size();
        }

        public int size() {
            return this.groupInfoList.size();
        }

        public boolean isEmpty() {
            return this.groupInfoList.isEmpty();
        }

        public Iterator<XInfoGroup> iterator() {
            return this.groupInfoList.iterator();
        }

        public XInfoGroup get(int index) {
            return this.groupInfoList.get(index);
        }

        public Stream<XInfoGroup> stream() {
            return this.groupInfoList.stream();
        }

        public void forEach(Consumer<? super XInfoGroup> action) {
            this.groupInfoList.forEach(action);
        }

        public String toString() {
            return "XInfoGroups" + String.valueOf(this.groupInfoList);
        }
    }

    public static class XInfoStream
    extends XInfoObject {
        private static final Map<String, Class<?>> typeHints = new HashMap(DEFAULT_TYPE_HINTS);

        private XInfoStream(List<Object> raw) {
            super(raw, typeHints);
        }

        public static XInfoStream fromList(List<Object> source) {
            return new XInfoStream(source);
        }

        public long streamLength() {
            return this.getRequired("length", Long.class);
        }

        public long radixTreeKeySize() {
            return this.getRequired("radix-tree-keys", Long.class);
        }

        public long radixTreeNodesSize() {
            return this.getRequired("radix-tree-nodes", Long.class);
        }

        public long groupCount() {
            return this.getRequired("groups", Long.class);
        }

        public String lastGeneratedId() {
            return this.getRequired("last-generated-id", String.class);
        }

        public String firstEntryId() {
            return this.getAndMap("first-entry", Map.class, it -> it.keySet().iterator().next().toString());
        }

        public Map<Object, Object> getFirstEntry() {
            return this.getAndMap("first-entry", Map.class, Collections::unmodifiableMap);
        }

        public String lastEntryId() {
            return this.getAndMap("last-entry", Map.class, it -> it.keySet().iterator().next().toString());
        }

        public Map<Object, Object> getLastEntry() {
            return this.getAndMap("last-entry", Map.class, Collections::unmodifiableMap);
        }

        static {
            typeHints.put("root.first-entry", Map.class);
            typeHints.put("root.first-entry.*", Map.class);
            typeHints.put("root.first-entry.*.*", Object.class);
            typeHints.put("root.last-entry", Map.class);
            typeHints.put("root.last-entry.*", Map.class);
            typeHints.put("root.last-entry.*.*", Object.class);
        }
    }

    public static class XInfoObject {
        protected static final Map<String, Class<?>> DEFAULT_TYPE_HINTS;
        private Map<String, Object> raw;

        private XInfoObject(List<Object> raw, Map<String, Class<?>> typeHints) {
            this((Map)Converters.parse(raw, "root", typeHints));
        }

        private XInfoObject(Map<String, Object> raw) {
            this.raw = raw;
        }

        @Nullable
        <T> T get(String entry, Class<T> type) {
            Object value = this.raw.get(entry);
            return value == null ? null : (T)type.cast(value);
        }

        <T> T getRequired(String entry, Class<T> type) {
            T value = this.get(entry, type);
            if (value == null) {
                throw new IllegalStateException("Value for entry '%s' is null".formatted(entry));
            }
            return value;
        }

        @Nullable
        <I, T> T getAndMap(String entry, Class<I> type, Function<I, T> f) {
            I value = this.get(entry, type);
            return value == null ? null : (T)f.apply(value);
        }

        public Map<String, Object> getRaw() {
            return this.raw;
        }

        public String toString() {
            return "XInfoStream" + String.valueOf(this.raw);
        }

        static {
            HashMap<String, Class> defaults = new HashMap<String, Class>(2);
            defaults.put("root", Map.class);
            defaults.put("root.*", String.class);
            DEFAULT_TYPE_HINTS = Collections.unmodifiableMap(defaults);
        }
    }
}

