/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.function.Consumer;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.data.redis.cache.CacheKeyPrefix;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisCacheConfiguration {
    private final Duration ttl;
    private final boolean cacheNullValues;
    private final CacheKeyPrefix keyPrefix;
    private final boolean usePrefix;
    private final RedisSerializationContext.SerializationPair<String> keySerializationPair;
    private final RedisSerializationContext.SerializationPair<Object> valueSerializationPair;
    private final ConversionService conversionService;

    private RedisCacheConfiguration(Duration ttl, Boolean cacheNullValues, Boolean usePrefix, CacheKeyPrefix keyPrefix, RedisSerializationContext.SerializationPair<String> keySerializationPair, RedisSerializationContext.SerializationPair<?> valueSerializationPair, ConversionService conversionService) {
        this.ttl = ttl;
        this.cacheNullValues = cacheNullValues;
        this.usePrefix = usePrefix;
        this.keyPrefix = keyPrefix;
        this.keySerializationPair = keySerializationPair;
        this.valueSerializationPair = valueSerializationPair;
        this.conversionService = conversionService;
    }

    public static RedisCacheConfiguration defaultCacheConfig() {
        return RedisCacheConfiguration.defaultCacheConfig(null);
    }

    public static RedisCacheConfiguration defaultCacheConfig(@Nullable ClassLoader classLoader) {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        RedisCacheConfiguration.registerDefaultConverters((ConverterRegistry)conversionService);
        return new RedisCacheConfiguration(Duration.ZERO, true, true, CacheKeyPrefix.simple(), RedisSerializationContext.SerializationPair.fromSerializer(RedisSerializer.string()), RedisSerializationContext.SerializationPair.fromSerializer(RedisSerializer.java(classLoader)), (ConversionService)conversionService);
    }

    public RedisCacheConfiguration entryTtl(Duration ttl) {
        Assert.notNull((Object)ttl, (String)"TTL duration must not be null");
        return new RedisCacheConfiguration(ttl, this.cacheNullValues, this.usePrefix, this.keyPrefix, this.keySerializationPair, this.valueSerializationPair, this.conversionService);
    }

    public RedisCacheConfiguration prefixCacheNameWith(String prefix) {
        return this.computePrefixWith(CacheKeyPrefix.prefixed(prefix));
    }

    public RedisCacheConfiguration computePrefixWith(CacheKeyPrefix cacheKeyPrefix) {
        Assert.notNull((Object)cacheKeyPrefix, (String)"Function for computing prefix must not be null");
        return new RedisCacheConfiguration(this.ttl, this.cacheNullValues, true, cacheKeyPrefix, this.keySerializationPair, this.valueSerializationPair, this.conversionService);
    }

    public RedisCacheConfiguration disableCachingNullValues() {
        return new RedisCacheConfiguration(this.ttl, false, this.usePrefix, this.keyPrefix, this.keySerializationPair, this.valueSerializationPair, this.conversionService);
    }

    public RedisCacheConfiguration disableKeyPrefix() {
        return new RedisCacheConfiguration(this.ttl, this.cacheNullValues, false, this.keyPrefix, this.keySerializationPair, this.valueSerializationPair, this.conversionService);
    }

    public RedisCacheConfiguration withConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        return new RedisCacheConfiguration(this.ttl, this.cacheNullValues, this.usePrefix, this.keyPrefix, this.keySerializationPair, this.valueSerializationPair, conversionService);
    }

    public RedisCacheConfiguration serializeKeysWith(RedisSerializationContext.SerializationPair<String> keySerializationPair) {
        Assert.notNull(keySerializationPair, (String)"KeySerializationPair must not be null");
        return new RedisCacheConfiguration(this.ttl, this.cacheNullValues, this.usePrefix, this.keyPrefix, keySerializationPair, this.valueSerializationPair, this.conversionService);
    }

    public RedisCacheConfiguration serializeValuesWith(RedisSerializationContext.SerializationPair<?> valueSerializationPair) {
        Assert.notNull(valueSerializationPair, (String)"ValueSerializationPair must not be null");
        return new RedisCacheConfiguration(this.ttl, this.cacheNullValues, this.usePrefix, this.keyPrefix, this.keySerializationPair, valueSerializationPair, this.conversionService);
    }

    public String getKeyPrefixFor(String cacheName) {
        Assert.notNull((Object)cacheName, (String)"Cache name must not be null");
        return this.keyPrefix.compute(cacheName);
    }

    public boolean usePrefix() {
        return this.usePrefix;
    }

    public boolean getAllowCacheNullValues() {
        return this.cacheNullValues;
    }

    public RedisSerializationContext.SerializationPair<String> getKeySerializationPair() {
        return this.keySerializationPair;
    }

    public RedisSerializationContext.SerializationPair<Object> getValueSerializationPair() {
        return this.valueSerializationPair;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void addCacheKeyConverter(Converter<?, String> cacheKeyConverter) {
        this.configureKeyConverters(it -> it.addConverter(cacheKeyConverter));
    }

    public void configureKeyConverters(Consumer<ConverterRegistry> registryConsumer) {
        if (!(this.getConversionService() instanceof ConverterRegistry)) {
            throw new IllegalStateException(String.format("'%s' returned by getConversionService() does not allow converter registration; Please make sure to provide a ConversionService that implements ConverterRegistry", this.getConversionService().getClass().getSimpleName()));
        }
        registryConsumer.accept((ConverterRegistry)this.getConversionService());
    }

    public static void registerDefaultConverters(ConverterRegistry registry) {
        Assert.notNull((Object)registry, (String)"ConverterRegistry must not be null");
        registry.addConverter(String.class, byte[].class, source -> source.getBytes(StandardCharsets.UTF_8));
        registry.addConverter(SimpleKey.class, String.class, SimpleKey::toString);
    }
}

