/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.support;

import java.util.List;
import java.util.function.IntFunction;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Window;

public class ScrollDelegate {
    static <T> Window<T> createWindow(List<T> result, int limit, IntFunction<? extends ScrollPosition> positionFunction) {
        return Window.from(ScrollDelegate.getFirst(limit, result), positionFunction, (boolean)ScrollDelegate.hasMoreElements(result, limit));
    }

    private static boolean hasMoreElements(List<?> result, int limit) {
        return !result.isEmpty() && result.size() > limit;
    }

    public static <T> List<T> getFirst(int count, List<T> list) {
        if (count > 0 && list.size() > count) {
            return list.subList(0, count);
        }
        return list;
    }
}

