/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
public final class MappingSupport {
    @Nullable
    public static Collection<?> unifyRelationshipValue(Neo4jPersistentProperty property, Object rawValue) {
        Collection<Object> unifiedValue = property.isDynamicAssociation() ? (property.isDynamicOneToManyAssociation() ? (Collection)((Map)rawValue).entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream().map(v -> new AbstractMap.SimpleEntry(e.getKey(), v))).collect(Collectors.toList()) : ((Map)rawValue).entrySet()) : (property.isRelationshipWithProperties() ? (Set)rawValue : (property.isCollectionLike() ? (Collection)rawValue : Collections.singleton(rawValue)));
        return unifiedValue;
    }

    private MappingSupport() {
    }

    @API(status=API.Status.INTERNAL)
    static final class RelationshipPropertiesWithEntityHolder {
        private final Object relationshipProperties;
        private final Object relatedEntity;

        RelationshipPropertiesWithEntityHolder(Object relationshipProperties, Object relatedEntity) {
            this.relationshipProperties = relationshipProperties;
            this.relatedEntity = relatedEntity;
        }

        Object getRelationshipProperties() {
            return this.relationshipProperties;
        }

        Object getRelatedEntity() {
            return this.relatedEntity;
        }
    }
}

