/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.BinaryVector;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Vector;
import org.springframework.data.mongodb.core.aggregation.VectorSearchOperation;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.VectorSearch;
import org.springframework.data.mongodb.repository.aot.AotStringQuery;
import org.springframework.data.mongodb.repository.aot.DocumentSerializer;
import org.springframework.data.mongodb.repository.aot.MongoInteraction;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.repository.aot.generate.QueryMetadata;
import org.springframework.util.StringUtils;

class SearchInteraction
extends MongoInteraction
implements QueryMetadata {
    private final Class<?> domainType;
    private final AotStringQuery filter;
    private final VectorSearch vectorSearch;
    private final MongoParameters parameters;
    private final MongoMappingContext mappingContext;

    public SearchInteraction(Class<?> domainType, VectorSearch vectorSearch, AotStringQuery filter, MongoParameters parameters, MongoMappingContext mappingContext) {
        this.domainType = domainType;
        this.vectorSearch = vectorSearch;
        this.filter = filter;
        this.parameters = parameters;
        this.mappingContext = mappingContext;
    }

    public AotStringQuery getFilter() {
        return this.filter;
    }

    @Nullable String getIndexName() {
        return this.vectorSearch.indexName();
    }

    public MongoParameters getParameters() {
        return this.parameters;
    }

    @Override
    MongoInteraction.InteractionType getExecutionType() {
        return MongoInteraction.InteractionType.AGGREGATION;
    }

    public Map<String, Object> serialize() {
        String limit;
        LinkedHashMap<String, Object> serialized = new LinkedHashMap<String, Object>();
        if (StringUtils.hasText((String)this.vectorSearch.indexName())) {
            serialized.put("index", this.vectorSearch.indexName());
        }
        serialized.put("path", this.getSearchPath());
        if (this.vectorSearch.searchType().equals((Object)VectorSearchOperation.SearchType.ENN)) {
            serialized.put("exact", true);
        }
        if (StringUtils.hasText((String)this.filter.getQueryString())) {
            serialized.put("filter", this.filter.getQueryString());
        }
        if (StringUtils.hasText((String)(limit = this.limitParameter()))) {
            serialized.put("limit", limit);
        }
        if (StringUtils.hasText((String)this.vectorSearch.numCandidates())) {
            serialized.put("numCandidates", this.vectorSearch.numCandidates());
        } else if (StringUtils.hasText((String)limit)) {
            serialized.put("numCandidates", limit + " * 20");
        }
        serialized.put("queryVector", "?" + this.parameters.getVectorIndex());
        String $vectorSearch = DocumentSerializer.toJson(new Document("$vectorSearch", serialized));
        return Map.of("pipeline", List.of($vectorSearch));
    }

    private @Nullable String limitParameter() {
        if (this.parameters.hasLimitParameter()) {
            return "?" + this.parameters.getLimitIndex();
        }
        if (StringUtils.hasText((String)this.vectorSearch.limit())) {
            return this.vectorSearch.limit();
        }
        return null;
    }

    public String getSearchPath() {
        if (StringUtils.hasText((String)this.vectorSearch.path())) {
            return this.vectorSearch.path();
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(this.domainType);
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty property = (MongoPersistentProperty)iterator.next();
            if (!Vector.class.isAssignableFrom(property.getActualType()) && !BinaryVector.class.isAssignableFrom(property.getActualType())) continue;
            return property.getName();
        }
        throw new IllegalArgumentException("No vector search path found for type %s".formatted(this.domainType));
    }
}

