/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import java.util.function.Function;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEvent;

public class MongoMappingEvent<T>
extends ApplicationEvent {
    private static final long serialVersionUID = 1L;
    private final @Nullable Document document;
    private final @Nullable String collectionName;

    public MongoMappingEvent(T source, @Nullable Document document, @Nullable String collectionName) {
        super(source);
        this.document = document;
        this.collectionName = collectionName;
    }

    public @Nullable Document getDocument() {
        return this.document;
    }

    public @Nullable String getCollectionName() {
        return this.collectionName;
    }

    public T getSource() {
        return (T)super.getSource();
    }

    final void mapSource(Function<T, T> mapper) {
        if (this.source == null) {
            return;
        }
        this.source = mapper.apply(this.getSource());
    }
}

