/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.VariableOperators;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MergeOperation
implements FieldsExposingAggregationOperation,
FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private final MergeOperationTarget into;
    private final UniqueMergeId on;
    private final @Nullable VariableOperators.Let let;
    private final @Nullable WhenDocumentsMatch whenMatched;
    private final @Nullable WhenDocumentsDontMatch whenNotMatched;

    public MergeOperation(MergeOperationTarget into, UniqueMergeId on, @Nullable VariableOperators.Let let, @Nullable WhenDocumentsMatch whenMatched, @Nullable WhenDocumentsDontMatch whenNotMatched) {
        Assert.notNull((Object)into, (String)"Into must not be null Please provide a target collection");
        Assert.notNull((Object)on, (String)"On must not be null Use UniqueMergeId.id() instead");
        this.into = into;
        this.on = on;
        this.let = let;
        this.whenMatched = whenMatched;
        this.whenNotMatched = whenNotMatched;
    }

    public static MergeOperation mergeInto(String collection) {
        return MergeOperation.builder().intoCollection(collection).build();
    }

    public static MergeOperationBuilder builder() {
        return new MergeOperationBuilder();
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        if (this.isJustCollection()) {
            return new Document(this.getOperator(), (Object)this.into.collection);
        }
        Document $merge = new Document();
        $merge.putAll((Map)this.into.toDocument(context));
        if (!this.on.isJustIdField()) {
            $merge.putAll((Map)this.on.toDocument(context));
        }
        if (this.let != null) {
            $merge.append("let", ((Document)this.let.toDocument(context).get((Object)"$let", Document.class)).get((Object)"vars"));
        }
        if (this.whenMatched != null) {
            $merge.putAll((Map)this.whenMatched.toDocument(context));
        }
        if (this.whenNotMatched != null) {
            $merge.putAll((Map)this.whenNotMatched.toDocument(context));
        }
        return new Document(this.getOperator(), (Object)$merge);
    }

    @Override
    public String getOperator() {
        return "$merge";
    }

    @Override
    public ExposedFields getFields() {
        if (this.let == null) {
            return ExposedFields.from(new ExposedFields.ExposedField[0]);
        }
        return ExposedFields.synthetic(Fields.fields(this.let.getVariableNames()));
    }

    @Override
    public boolean inheritsFields() {
        return true;
    }

    private boolean isJustCollection() {
        return this.into.isTargetingSameDatabase() && this.on.isJustIdField() && this.let == null && this.whenMatched == null && this.whenNotMatched == null;
    }

    public static class MergeOperationTarget {
        private final @Nullable String database;
        private final String collection;

        private MergeOperationTarget(@Nullable String database, String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty");
            this.database = database;
            this.collection = collection;
        }

        public static MergeOperationTarget collection(String collection) {
            return new MergeOperationTarget(null, collection);
        }

        public MergeOperationTarget inDatabase(String database) {
            return new MergeOperationTarget(database, this.collection);
        }

        boolean isTargetingSameDatabase() {
            return !StringUtils.hasText((String)this.database);
        }

        Document toDocument(AggregationOperationContext context) {
            return new Document("into", (Object)(!StringUtils.hasText((String)this.database) ? this.collection : new Document("db", (Object)this.database).append("coll", (Object)this.collection)));
        }
    }

    public static class UniqueMergeId {
        private static final UniqueMergeId ID = new UniqueMergeId(Collections.emptyList());
        private final Collection<String> uniqueIdentifier;

        private UniqueMergeId(Collection<String> uniqueIdentifier) {
            this.uniqueIdentifier = uniqueIdentifier;
        }

        public static UniqueMergeId ofIdFields(String ... fields) {
            Assert.noNullElements((Object[])fields, (String)"Fields must not contain null values");
            if (ObjectUtils.isEmpty((Object[])fields)) {
                return UniqueMergeId.id();
            }
            return new UniqueMergeId(Arrays.asList(fields));
        }

        public static UniqueMergeId id() {
            return ID;
        }

        boolean isJustIdField() {
            return this.equals(ID);
        }

        Document toDocument(AggregationOperationContext context) {
            List mappedOn = this.uniqueIdentifier.stream().map(context::getReference).map(ExposedFields.FieldReference::getRaw).collect(Collectors.toList());
            return new Document("on", mappedOn.size() == 1 ? mappedOn.iterator().next() : mappedOn);
        }
    }

    public static class WhenDocumentsMatch {
        private final Object value;

        private WhenDocumentsMatch(Object value) {
            this.value = value;
        }

        public static WhenDocumentsMatch whenMatchedOf(String value) {
            return new WhenDocumentsMatch(value);
        }

        public static WhenDocumentsMatch replaceDocument() {
            return WhenDocumentsMatch.whenMatchedOf("replace");
        }

        public static WhenDocumentsMatch keepExistingDocument() {
            return WhenDocumentsMatch.whenMatchedOf("keepExisting");
        }

        public static WhenDocumentsMatch mergeDocuments() {
            return WhenDocumentsMatch.whenMatchedOf("merge");
        }

        public static WhenDocumentsMatch failOnMatch() {
            return WhenDocumentsMatch.whenMatchedOf("fail");
        }

        public static WhenDocumentsMatch updateWith(Aggregation aggregation) {
            return new WhenDocumentsMatch(aggregation);
        }

        public static WhenDocumentsMatch updateWith(List<AggregationOperation> aggregationPipeline) {
            return new WhenDocumentsMatch(aggregationPipeline);
        }

        Document toDocument(AggregationOperationContext context) {
            Object object = this.value;
            if (object instanceof Aggregation) {
                Aggregation aggregation = (Aggregation)object;
                return new Document("whenMatched", aggregation.toPipeline(context));
            }
            return new Document("whenMatched", this.value);
        }
    }

    public static class WhenDocumentsDontMatch {
        private final String value;

        private WhenDocumentsDontMatch(String value) {
            Assert.notNull((Object)value, (String)"Value must not be null");
            this.value = value;
        }

        public static WhenDocumentsDontMatch whenNotMatchedOf(String value) {
            return new WhenDocumentsDontMatch(value);
        }

        public static WhenDocumentsDontMatch insertNewDocument() {
            return WhenDocumentsDontMatch.whenNotMatchedOf("insert");
        }

        public static WhenDocumentsDontMatch discardDocument() {
            return WhenDocumentsDontMatch.whenNotMatchedOf("discard");
        }

        public static WhenDocumentsDontMatch failWhenNotMatch() {
            return WhenDocumentsDontMatch.whenNotMatchedOf("fail");
        }

        public Document toDocument(AggregationOperationContext context) {
            return new Document("whenNotMatched", (Object)this.value);
        }
    }

    public static class MergeOperationBuilder {
        private @Nullable String collection;
        private @Nullable String database;
        private UniqueMergeId id = UniqueMergeId.id();
        private @Nullable VariableOperators.Let let;
        private @Nullable WhenDocumentsMatch whenMatched;
        private @Nullable WhenDocumentsDontMatch whenNotMatched;

        @Contract(value="_ -> this")
        public MergeOperationBuilder intoCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty");
            this.collection = collection;
            return this;
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder inDatabase(String database) {
            this.database = database;
            return this;
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder into(MergeOperationTarget into) {
            this.database = into.database;
            this.collection = into.collection;
            return this;
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder target(MergeOperationTarget target) {
            return this.into(target);
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder on(String ... fields) {
            return this.id(UniqueMergeId.ofIdFields(fields));
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder id(UniqueMergeId id) {
            this.id = id;
            return this;
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder let(VariableOperators.Let let) {
            this.let = let;
            return this;
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder exposeVariablesOf(VariableOperators.Let let) {
            return this.let(let);
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder whenMatched(WhenDocumentsMatch whenMatched) {
            this.whenMatched = whenMatched;
            return this;
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder whenDocumentsMatch(WhenDocumentsMatch whenMatched) {
            return this.whenMatched(whenMatched);
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder whenDocumentsMatchApply(Aggregation aggregation) {
            return this.whenMatched(WhenDocumentsMatch.updateWith(aggregation));
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder whenNotMatched(WhenDocumentsDontMatch whenNotMatched) {
            this.whenNotMatched = whenNotMatched;
            return this;
        }

        @Contract(value="_ -> this")
        public MergeOperationBuilder whenDocumentsDontMatch(WhenDocumentsDontMatch whenNotMatched) {
            return this.whenNotMatched(whenNotMatched);
        }

        @Contract(value="-> new")
        public MergeOperation build() {
            Assert.notNull((Object)this.collection, (String)"Collection must not be null");
            return new MergeOperation(new MergeOperationTarget(this.database, this.collection), this.id, this.let, this.whenMatched, this.whenNotMatched);
        }
    }
}

