/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.Collection;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.data.mongodb.UncategorizedMongoDbException;
import org.springframework.data.mongodb.core.IndexConverters;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.index.IndexOptions;
import org.springframework.data.mongodb.core.index.ReactiveIndexOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultReactiveIndexOperations
implements ReactiveIndexOperations {
    private static final String PARTIAL_FILTER_EXPRESSION_KEY = "partialFilterExpression";
    private final ReactiveMongoOperations mongoOperations;
    private final String collectionName;
    private final QueryMapper queryMapper;
    private final @Nullable Class<?> type;

    public DefaultReactiveIndexOperations(ReactiveMongoOperations mongoOperations, String collectionName, QueryMapper queryMapper) {
        this(mongoOperations, collectionName, queryMapper, null);
    }

    public DefaultReactiveIndexOperations(ReactiveMongoOperations mongoOperations, String collectionName, QueryMapper queryMapper, @Nullable Class<?> type) {
        Assert.notNull((Object)mongoOperations, (String)"ReactiveMongoOperations must not be null");
        Assert.notNull((Object)collectionName, (String)"Collection must not be null");
        Assert.notNull((Object)queryMapper, (String)"QueryMapper must not be null");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
        this.queryMapper = queryMapper;
        this.type = type;
    }

    @Override
    public Mono<String> createIndex(IndexDefinition indexDefinition) {
        return this.mongoOperations.execute(this.collectionName, collection -> {
            MongoPersistentEntity<?> entity = this.getConfiguredEntity();
            com.mongodb.client.model.IndexOptions indexOptions = (com.mongodb.client.model.IndexOptions)IndexConverters.indexDefinitionToIndexOptionsConverter().convert((Object)indexDefinition);
            indexOptions = this.addPartialFilterIfPresent(indexOptions, indexDefinition.getIndexOptions(), entity);
            indexOptions = DefaultReactiveIndexOperations.addDefaultCollationIfRequired(indexOptions, entity);
            return collection.createIndex((Bson)indexDefinition.getIndexKeys(), indexOptions);
        }).next();
    }

    @Override
    public Mono<Void> alterIndex(String name, IndexOptions options) {
        return this.mongoOperations.execute(db -> {
            Document indexOptions = new Document("name", (Object)name);
            indexOptions.putAll((Map)options.toDocument());
            return Flux.from((Publisher)db.runCommand((Bson)new Document("collMod", (Object)this.collectionName).append("index", (Object)indexOptions))).doOnNext(result -> {
                if ((Integer)NumberUtils.convertNumberToTargetClass((Number)((Number)result.get((Object)"ok", (Object)0)), Integer.class) != 1) {
                    throw new UncategorizedMongoDbException("Index '%s' could not be modified. Response was %s".formatted(name, result.toJson()), null);
                }
            });
        }).then();
    }

    private @Nullable MongoPersistentEntity<?> lookupPersistentEntity(String collection) {
        Collection entities = this.queryMapper.getMappingContext().getPersistentEntities();
        return entities.stream().filter(entity -> entity.getCollection().equals(collection)).findFirst().orElse(null);
    }

    @Override
    public Mono<Void> dropIndex(String name) {
        return this.mongoOperations.execute(this.collectionName, collection -> collection.dropIndex(name)).then();
    }

    @Override
    public Mono<Void> dropAllIndexes() {
        return this.dropIndex("*");
    }

    @Override
    public Flux<IndexInfo> getIndexInfo() {
        return this.mongoOperations.execute(this.collectionName, collection -> collection.listIndexes(Document.class)).map(arg_0 -> IndexConverters.documentToIndexInfoConverter().convert(arg_0));
    }

    private @Nullable MongoPersistentEntity<?> getConfiguredEntity() {
        if (this.type != null) {
            return (MongoPersistentEntity)this.queryMapper.getMappingContext().getRequiredPersistentEntity(this.type);
        }
        return this.lookupPersistentEntity(this.collectionName);
    }

    private com.mongodb.client.model.IndexOptions addPartialFilterIfPresent(com.mongodb.client.model.IndexOptions ops, Document sourceOptions, @Nullable MongoPersistentEntity<?> entity) {
        if (!sourceOptions.containsKey((Object)PARTIAL_FILTER_EXPRESSION_KEY)) {
            return ops;
        }
        Assert.isInstanceOf(Document.class, (Object)sourceOptions.get((Object)PARTIAL_FILTER_EXPRESSION_KEY));
        return ops.partialFilterExpression((Bson)this.queryMapper.getMappedObject((Bson)((Document)sourceOptions.get((Object)PARTIAL_FILTER_EXPRESSION_KEY)), entity));
    }

    private static com.mongodb.client.model.IndexOptions addDefaultCollationIfRequired(com.mongodb.client.model.IndexOptions ops, @Nullable MongoPersistentEntity<?> entity) {
        if (ops.getCollation() != null || entity == null || !entity.hasCollation()) {
            return ops;
        }
        return ops.collation(entity.getCollation().toMongoCollation());
    }
}

