/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import java.util.Map;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class DefaultMongoJsonSchema
implements MongoJsonSchema {
    private final JsonSchemaObject root;
    private final @Nullable Document encryptionMetadata;

    DefaultMongoJsonSchema(JsonSchemaObject root) {
        this(root, null);
    }

    DefaultMongoJsonSchema(JsonSchemaObject root, @Nullable Document encryptionMetadata) {
        Assert.notNull((Object)root, (String)"Root schema object must not be null");
        this.root = root;
        this.encryptionMetadata = encryptionMetadata;
    }

    @Override
    public Document schemaDocument() {
        Document schemaDocument = new Document();
        if (!CollectionUtils.isEmpty((Map)this.encryptionMetadata)) {
            schemaDocument.append("encryptMetadata", (Object)this.encryptionMetadata);
        }
        schemaDocument.putAll((Map)this.root.toDocument());
        return schemaDocument;
    }
}

