/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Update
implements UpdateDefinition {
    private boolean isolated = false;
    private final Set<String> keysToUpdate = new HashSet<String>();
    private final Map<String, Object> modifierOps = new LinkedHashMap<String, Object>();
    private Map<String, PushOperatorBuilder> pushCommandBuilders = Collections.emptyMap();
    private List<UpdateDefinition.ArrayFilter> arrayFilters = Collections.emptyList();

    public static Update update(String key, @Nullable Object value) {
        return new Update().set(key, value);
    }

    public static Update fromDocument(Document object, String ... exclude) {
        Update update = new Update();
        List<String> excludeList = Arrays.asList(exclude);
        for (String key : object.keySet()) {
            if (excludeList.contains(key)) continue;
            Object value = object.get((Object)key);
            update.modifierOps.put(key, value);
            if (Update.isKeyword(key) && value instanceof Document) {
                Document document = (Document)value;
                update.keysToUpdate.addAll(document.keySet());
                continue;
            }
            update.keysToUpdate.add(key);
        }
        return update;
    }

    @Contract(value="_, _ -> this")
    public Update set(String key, @Nullable Object value) {
        this.addMultiFieldOperation("$set", key, value);
        return this;
    }

    @Contract(value="_, _ -> this")
    public Update setOnInsert(String key, @Nullable Object value) {
        this.addMultiFieldOperation("$setOnInsert", key, value);
        return this;
    }

    @Contract(value="_ -> this")
    public Update unset(String key) {
        this.addMultiFieldOperation("$unset", key, 1);
        return this;
    }

    @Contract(value="_, _ -> this")
    public Update inc(String key, Number inc) {
        this.addMultiFieldOperation("$inc", key, inc);
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    public Update inc(String key) {
        return this.inc(key, 1L);
    }

    @Contract(value="_, _ -> this")
    public Update push(String key, @Nullable Object value) {
        this.addMultiFieldOperation("$push", key, value);
        return this;
    }

    public PushOperatorBuilder push(String key) {
        if (!this.pushCommandBuilders.containsKey(key)) {
            if (this.pushCommandBuilders == Collections.EMPTY_MAP) {
                this.pushCommandBuilders = new LinkedHashMap<String, PushOperatorBuilder>(1);
            }
            this.pushCommandBuilders.put(key, new PushOperatorBuilder(key));
        }
        return this.pushCommandBuilders.get(key);
    }

    @Contract(value="_ -> new")
    public AddToSetBuilder addToSet(String key) {
        return new AddToSetBuilder(key);
    }

    @Contract(value="_, _ -> this")
    public Update addToSet(String key, @Nullable Object value) {
        this.addMultiFieldOperation("$addToSet", key, value);
        return this;
    }

    @Contract(value="_, _ -> this")
    public Update pop(String key, Position pos) {
        this.addMultiFieldOperation("$pop", key, pos == Position.FIRST ? -1 : 1);
        return this;
    }

    @Contract(value="_, _ -> this")
    public Update pull(String key, @Nullable Object value) {
        this.addMultiFieldOperation("$pull", key, value);
        return this;
    }

    @Contract(value="_, _ -> this")
    public Update pullAll(String key, Object[] values) {
        this.addMultiFieldOperation("$pullAll", key, Arrays.asList(values));
        return this;
    }

    @Contract(value="_, _ -> this")
    public Update rename(String oldName, String newName) {
        this.addMultiFieldOperation("$rename", oldName, newName);
        return this;
    }

    @Contract(value="_ -> this")
    public Update currentDate(String key) {
        this.addMultiFieldOperation("$currentDate", key, true);
        return this;
    }

    @Contract(value="_ -> this")
    public Update currentTimestamp(String key) {
        this.addMultiFieldOperation("$currentDate", key, new Document("$type", (Object)"timestamp"));
        return this;
    }

    @Contract(value="_, _ -> this")
    public Update multiply(String key, Number multiplier) {
        Assert.notNull((Object)multiplier, (String)"Multiplier must not be null");
        this.addMultiFieldOperation("$mul", key, multiplier.doubleValue());
        return this;
    }

    @Contract(value="_, _ -> this")
    public Update max(String key, Object value) {
        Assert.notNull((Object)value, (String)"Value for max operation must not be null");
        this.addMultiFieldOperation("$max", key, value);
        return this;
    }

    @Contract(value="_, _ -> this")
    public Update min(String key, Object value) {
        Assert.notNull((Object)value, (String)"Value for min operation must not be null");
        this.addMultiFieldOperation("$min", key, value);
        return this;
    }

    @Contract(value="_ -> new")
    public BitwiseOperatorBuilder bitwise(String key) {
        return new BitwiseOperatorBuilder(this, key);
    }

    @Contract(value="-> this")
    public Update isolated() {
        this.isolated = true;
        return this;
    }

    @Contract(value="_ -> this")
    public Update filterArray(CriteriaDefinition criteria) {
        if (this.arrayFilters == Collections.EMPTY_LIST) {
            this.arrayFilters = new ArrayList<UpdateDefinition.ArrayFilter>();
        }
        this.arrayFilters.add(criteria::getCriteriaObject);
        return this;
    }

    @Contract(value="_, _ -> this")
    public Update filterArray(String identifier, Object expression) {
        if (this.arrayFilters == Collections.EMPTY_LIST) {
            this.arrayFilters = new ArrayList<UpdateDefinition.ArrayFilter>();
        }
        this.arrayFilters.add(() -> new Document(identifier, expression));
        return this;
    }

    @Override
    public boolean isIsolated() {
        return this.isolated;
    }

    @Override
    public Document getUpdateObject() {
        return new Document(this.modifierOps);
    }

    @Override
    public List<UpdateDefinition.ArrayFilter> getArrayFilters() {
        return Collections.unmodifiableList(this.arrayFilters);
    }

    @Override
    public boolean hasArrayFilters() {
        return !this.arrayFilters.isEmpty();
    }

    protected void addMultiFieldOperation(String operator, String key, @Nullable Object value) {
        Document keyValueMap;
        Assert.hasText((String)key, (String)"Key/Path for update must not be null or blank");
        Object existingValue = this.modifierOps.get(operator);
        if (existingValue == null) {
            keyValueMap = new Document();
            this.modifierOps.put(operator, keyValueMap);
        } else if (existingValue instanceof Document) {
            Document document;
            keyValueMap = document = (Document)existingValue;
        } else {
            throw new InvalidDataAccessApiUsageException("Modifier Operations should be a LinkedHashMap but was " + String.valueOf(existingValue.getClass()));
        }
        keyValueMap.put(key, value);
        this.keysToUpdate.add(key);
    }

    @Override
    public boolean modifies(String key) {
        return this.keysToUpdate.contains(key);
    }

    private static boolean isKeyword(String key) {
        return StringUtils.startsWithIgnoreCase((String)key, (String)"$");
    }

    public int hashCode() {
        return Objects.hash(this.getUpdateObject(), this.isolated);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Update that = (Update)obj;
        if (this.isolated != that.isolated) {
            return false;
        }
        return Objects.equals(this.getUpdateObject(), that.getUpdateObject());
    }

    public String toString() {
        Document doc = this.getUpdateObject();
        if (this.isIsolated()) {
            doc.append("$isolated", (Object)1);
        }
        return SerializationUtils.serializeToJsonSafely(doc);
    }

    public class PushOperatorBuilder {
        private final String key;
        private final Modifiers modifiers;

        PushOperatorBuilder(String key) {
            this.key = key;
            this.modifiers = new Modifiers();
        }

        public Update each(Object ... values) {
            this.modifiers.addModifier(new Each(values));
            return Update.this.push(this.key, this.modifiers);
        }

        @Contract(value="_ -> this")
        public PushOperatorBuilder slice(int count) {
            this.modifiers.addModifier(new Slice(count));
            return this;
        }

        @Contract(value="_ -> this")
        public PushOperatorBuilder sort(Sort.Direction direction) {
            Assert.notNull((Object)direction, (String)"Direction must not be null");
            this.modifiers.addModifier(new SortModifier(direction));
            return this;
        }

        @Contract(value="_ -> this")
        public PushOperatorBuilder sort(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null");
            this.modifiers.addModifier(new SortModifier(sort));
            return this;
        }

        @Contract(value="_ -> this")
        public PushOperatorBuilder atPosition(int position) {
            this.modifiers.addModifier(new PositionModifier(position));
            return this;
        }

        @Contract(value="_ -> this")
        public PushOperatorBuilder atPosition(@Nullable Position position) {
            if (position == null || Position.LAST.equals((Object)position)) {
                return this;
            }
            this.modifiers.addModifier(new PositionModifier(0));
            return this;
        }

        public Update value(Object value) {
            if (this.modifiers.isEmpty()) {
                return Update.this.push(this.key, value);
            }
            this.modifiers.addModifier(new Each(Collections.singletonList(value)));
            return Update.this.push(this.key, this.modifiers);
        }

        public int hashCode() {
            return Objects.hash(this.getOuterType(), this.key, this.modifiers);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PushOperatorBuilder that = (PushOperatorBuilder)obj;
            if (!Objects.equals(this.getOuterType(), that.getOuterType())) {
                return false;
            }
            return Objects.equals(this.key, that.key) && Objects.equals(this.modifiers, that.modifiers);
        }

        private Update getOuterType() {
            return Update.this;
        }
    }

    public class AddToSetBuilder {
        private final String key;

        public AddToSetBuilder(String key) {
            this.key = key;
        }

        public Update each(Object ... values) {
            return Update.this.addToSet(this.key, new Each(values));
        }

        public Update value(Object value) {
            return Update.this.addToSet(this.key, value);
        }
    }

    public static enum Position {
        LAST,
        FIRST;

    }

    public static class BitwiseOperatorBuilder {
        private final String key;
        private final Update reference;
        private static final String BIT_OPERATOR = "$bit";

        protected BitwiseOperatorBuilder(Update reference, String key) {
            Assert.notNull((Object)reference, (String)"Reference must not be null");
            Assert.notNull((Object)key, (String)"Key must not be null");
            this.reference = reference;
            this.key = key;
        }

        public Update and(long value) {
            this.addFieldOperation(BitwiseOperator.AND, value);
            return this.reference;
        }

        public Update or(long value) {
            this.addFieldOperation(BitwiseOperator.OR, value);
            return this.reference;
        }

        public Update xor(long value) {
            this.addFieldOperation(BitwiseOperator.XOR, value);
            return this.reference;
        }

        private void addFieldOperation(BitwiseOperator operator, Number value) {
            this.reference.addMultiFieldOperation(BIT_OPERATOR, this.key, new Document(operator.toString(), (Object)value));
        }

        private static enum BitwiseOperator {
            AND,
            OR,
            XOR;


            public String toString() {
                return super.toString().toLowerCase();
            }
        }
    }

    private static class SortModifier
    extends AbstractModifier {
        private final Object sort;

        SortModifier(Sort.Direction direction) {
            Assert.notNull((Object)direction, (String)"Direction must not be null");
            this.sort = direction.isAscending() ? 1 : -1;
        }

        SortModifier(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null");
            for (Sort.Order order : sort) {
                if (!order.isIgnoreCase()) continue;
                throw new IllegalArgumentException(String.format("Given sort contained an Order for %s with ignore case; MongoDB does not support sorting ignoring case currently", order.getProperty()));
            }
            this.sort = sort;
        }

        @Override
        public String getKey() {
            return "$sort";
        }

        @Override
        public Object getValue() {
            return this.sort;
        }
    }

    private static class Slice
    extends AbstractModifier {
        private final int count;

        Slice(int count) {
            this.count = count;
        }

        @Override
        public String getKey() {
            return "$slice";
        }

        @Override
        public Object getValue() {
            return this.count;
        }
    }

    private static class PositionModifier
    extends AbstractModifier {
        private final int position;

        PositionModifier(int position) {
            this.position = position;
        }

        @Override
        public String getKey() {
            return "$position";
        }

        @Override
        public Object getValue() {
            return this.position;
        }
    }

    private static class Each
    extends AbstractModifier {
        private Object[] values;

        Each(Object ... values) {
            this.values = this.extractValues(values);
        }

        private Object[] extractValues(Object[] values) {
            Object object;
            if (values == null || values.length == 0) {
                return values;
            }
            if (values.length == 1 && (object = values[0]) instanceof Collection) {
                Collection collection = (Collection)object;
                return collection.toArray();
            }
            return Arrays.copyOf(values, values.length);
        }

        @Override
        public String getKey() {
            return "$each";
        }

        @Override
        public Object getValue() {
            return this.values;
        }
    }

    private static abstract class AbstractModifier
    implements Modifier {
        private AbstractModifier() {
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object)this.getKey()) + ObjectUtils.nullSafeHashCode((Object)this.getValue());
        }

        public boolean equals(@Nullable Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            if (!Objects.equals(this.getKey(), ((Modifier)that).getKey())) {
                return false;
            }
            return Objects.deepEquals(this.getValue(), ((Modifier)that).getValue());
        }

        public String toString() {
            return this.toJsonString();
        }
    }

    public static interface Modifier {
        public String getKey();

        public Object getValue();

        default public String toJsonString() {
            return SerializationUtils.serializeToJsonSafely(Collections.singletonMap(this.getKey(), this.getValue()));
        }
    }

    public static class Modifiers {
        private final Map<String, Modifier> modifiers = new LinkedHashMap<String, Modifier>(1);

        public Collection<Modifier> getModifiers() {
            return Collections.unmodifiableCollection(this.modifiers.values());
        }

        public void addModifier(Modifier modifier) {
            this.modifiers.put(modifier.getKey(), modifier);
        }

        public boolean isEmpty() {
            return this.modifiers.isEmpty();
        }

        public int hashCode() {
            return Objects.hashCode(this.modifiers);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Modifiers that = (Modifiers)obj;
            return Objects.equals(this.modifiers, that.modifiers);
        }

        public String toString() {
            return SerializationUtils.serializeToJsonSafely(this.modifiers);
        }
    }
}

