/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.util.Set;
import org.bson.Document;
import org.springframework.core.Ordered;
import org.springframework.data.mongodb.core.mapping.event.BeanValidationDelegate;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveCallback;

public class ValidatingEntityCallback
implements BeforeSaveCallback<Object>,
Ordered {
    private final BeanValidationDelegate delegate;
    private int order = 100;

    public ValidatingEntityCallback(Validator validator) {
        this.delegate = new BeanValidationDelegate(validator);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public Object onBeforeSave(Object entity, Document document, String collection) {
        Set<ConstraintViolation<Object>> violations = this.delegate.validate(entity);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        return entity;
    }
}

