/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexFilter;
import org.springframework.data.mongodb.core.index.IndexOptions;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Index
implements IndexDefinition {
    private final Map<String, Sort.Direction> fieldSpec = new LinkedHashMap<String, Sort.Direction>();
    private @Nullable String name;
    private boolean sparse = false;
    private boolean background = false;
    private final IndexOptions options = IndexOptions.none();
    private Optional<IndexFilter> filter = Optional.empty();
    private Optional<Collation> collation = Optional.empty();

    public Index() {
    }

    public Index(String key, Sort.Direction direction) {
        this.fieldSpec.put(key, direction);
    }

    @Contract(value="_, _ -> this")
    public Index on(String key, Sort.Direction direction) {
        this.fieldSpec.put(key, direction);
        return this;
    }

    @Contract(value="_ -> this")
    public Index named(String name) {
        this.name = name;
        return this;
    }

    @Contract(value="-> this")
    public Index unique() {
        this.options.setUnique(IndexOptions.Unique.YES);
        return this;
    }

    @Contract(value="-> this")
    public Index sparse() {
        this.sparse = true;
        return this;
    }

    @Contract(value="-> this")
    public Index background() {
        this.background = true;
        return this;
    }

    @Contract(value="-> this")
    public Index hidden() {
        this.options.setHidden(true);
        return this;
    }

    @Contract(value="_ -> this")
    public Index expire(long value) {
        return this.expire(value, TimeUnit.SECONDS);
    }

    @Contract(value="_ -> this")
    public Index expire(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        return this.expire(timeout.getSeconds());
    }

    @Contract(value="_, _ -> this")
    public Index expire(long value, TimeUnit unit) {
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit for expiration must not be null");
        this.options.setExpire(Duration.ofSeconds(unit.toSeconds(value)));
        return this;
    }

    @Contract(value="_ -> this")
    public Index partial(@Nullable IndexFilter filter) {
        this.filter = Optional.ofNullable(filter);
        return this;
    }

    @Contract(value="_ -> this")
    public Index collation(@Nullable Collation collation) {
        this.collation = Optional.ofNullable(collation);
        return this;
    }

    @Override
    public Document getIndexKeys() {
        Document document = new Document();
        for (Map.Entry<String, Sort.Direction> entry : this.fieldSpec.entrySet()) {
            document.put(entry.getKey(), (Object)(Sort.Direction.ASC.equals((Object)entry.getValue()) ? 1 : -1));
        }
        return document;
    }

    @Override
    public Document getIndexOptions() {
        Document document = new Document();
        if (StringUtils.hasText((String)this.name)) {
            document.put("name", (Object)this.name);
        }
        if (this.sparse) {
            document.put("sparse", (Object)true);
        }
        if (this.background) {
            document.put("background", (Object)true);
        }
        document.putAll((Map)this.options.toDocument());
        this.filter.ifPresent(val -> document.put("partialFilterExpression", (Object)val.getFilterObject()));
        this.collation.ifPresent(val -> document.append("collation", (Object)val.toDocument()));
        return document;
    }

    public String toString() {
        return String.format("Index: %s - Options: %s", this.getIndexKeys(), this.getIndexOptions());
    }
}

