/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.GeoJsonLineString;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GeoJsonPolygon
extends Polygon
implements GeoJson<List<GeoJsonLineString>> {
    private static final long serialVersionUID = 3936163018187247185L;
    private static final String TYPE = "Polygon";
    private final List<GeoJsonLineString> coordinates = new ArrayList<GeoJsonLineString>(1);

    public GeoJsonPolygon(Point first, Point second, Point third, Point fourth, Point ... others) {
        this(GeoJsonPolygon.asList(first, second, third, fourth, others));
    }

    public GeoJsonPolygon(List<Point> points) {
        super(points);
        this.coordinates.add(new GeoJsonLineString(points));
    }

    @Contract(value="_, _, _, _, _ -> new")
    public GeoJsonPolygon withInnerRing(Point first, Point second, Point third, Point fourth, Point ... others) {
        return this.withInnerRing(GeoJsonPolygon.asList(first, second, third, fourth, others));
    }

    @Contract(value="_ -> new")
    public GeoJsonPolygon withInnerRing(List<Point> points) {
        return this.withInnerRing(new GeoJsonLineString(points));
    }

    @Contract(value="_ -> new")
    public GeoJsonPolygon withInnerRing(GeoJsonLineString lineString) {
        Assert.notNull((Object)lineString, (String)"LineString must not be null");
        Iterator<GeoJsonLineString> it = this.coordinates.iterator();
        GeoJsonPolygon polygon = new GeoJsonPolygon((List<Point>)it.next().getCoordinates());
        while (it.hasNext()) {
            polygon.coordinates.add(it.next());
        }
        polygon.coordinates.add(lineString);
        return polygon;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public List<GeoJsonLineString> getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    private static List<Point> asList(Point first, Point second, Point third, Point fourth, Point ... others) {
        Assert.notNull((Object)first, (String)"First point must not be null");
        Assert.notNull((Object)second, (String)"Second point must not be null");
        Assert.notNull((Object)third, (String)"Third point must not be null");
        Assert.notNull((Object)fourth, (String)"Fourth point must not be null");
        Assert.notNull((Object)others, (String)"Additional points must not be null");
        ArrayList<Point> result = new ArrayList<Point>(4 + others.length);
        result.add(first);
        result.add(second);
        result.add(third);
        result.add(fourth);
        result.addAll(Arrays.asList(others));
        return result;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoJsonPolygon that = (GeoJsonPolygon)o;
        return ObjectUtils.nullSafeEquals(this.coordinates, that.coordinates);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.coordinates);
        return result;
    }
}

