/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.function.Function;
import org.bson.conversions.Bson;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.util.StringUtils;

class HintFunction {
    private static final HintFunction EMPTY = new HintFunction(null);
    private final @Nullable Object hint;

    private HintFunction(@Nullable Object hint) {
        this.hint = hint;
    }

    static HintFunction empty() {
        return EMPTY;
    }

    static HintFunction from(@Nullable Object hint) {
        return new HintFunction(hint);
    }

    public boolean isPresent() {
        String hintString;
        Object object = this.hint;
        return object instanceof String && StringUtils.hasText((String)(hintString = (String)object)) || this.hint instanceof Bson;
    }

    public boolean isEmpty() {
        return !this.isPresent();
    }

    public <R> void ifPresent(@Nullable CodecRegistryProvider registryProvider, Function<String, R> stringConsumer, Function<Bson, R> bsonConsumer) {
        if (this.isEmpty()) {
            return;
        }
        this.apply(registryProvider, stringConsumer, bsonConsumer);
    }

    public <R> R apply(@Nullable CodecRegistryProvider registryProvider, Function<String, R> stringConsumer, Function<Bson, R> bsonConsumer) {
        if (this.isEmpty()) {
            throw new IllegalStateException("No hint present");
        }
        Object object = this.hint;
        if (object instanceof Bson) {
            Bson bson = (Bson)object;
            return bsonConsumer.apply(bson);
        }
        object = this.hint;
        if (object instanceof String) {
            String hintString = (String)object;
            if (BsonUtils.isJsonDocument(hintString)) {
                return bsonConsumer.apply((Bson)BsonUtils.parse(hintString, registryProvider));
            }
            return stringConsumer.apply(hintString);
        }
        throw new IllegalStateException("Unable to read hint of type %s".formatted(this.hint != null ? this.hint.getClass() : "null"));
    }
}

