/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.session.ClientSession;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Optional;
import java.util.function.BiFunction;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodClassKey;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class SessionAwareMethodInterceptor<D, C>
implements MethodInterceptor {
    private static final MethodCache METHOD_CACHE = new MethodCache();
    private final ClientSession session;
    private final ClientSessionOperator collectionDecorator;
    private final ClientSessionOperator databaseDecorator;
    private final Object target;
    private final Class<?> targetType;
    private final Class<?> collectionType;
    private final Class<?> databaseType;
    private final Class<? extends ClientSession> sessionType;

    public <T> SessionAwareMethodInterceptor(ClientSession session, T target, Class<? extends ClientSession> sessionType, Class<D> databaseType, ClientSessionOperator<D> databaseDecorator, Class<C> collectionType, ClientSessionOperator<C> collectionDecorator) {
        Assert.notNull((Object)session, (String)"ClientSession must not be null");
        Assert.notNull(target, (String)"Target must not be null");
        Assert.notNull(sessionType, (String)"SessionType must not be null");
        Assert.notNull(databaseType, (String)"Database type must not be null");
        Assert.notNull(databaseDecorator, (String)"Database ClientSessionOperator must not be null");
        Assert.notNull(collectionType, (String)"Collection type must not be null");
        Assert.notNull(collectionDecorator, (String)"Collection ClientSessionOperator must not be null");
        this.session = session;
        this.target = target;
        this.databaseType = ClassUtils.getUserClass(databaseType);
        this.collectionType = ClassUtils.getUserClass(collectionType);
        this.collectionDecorator = collectionDecorator;
        this.databaseDecorator = databaseDecorator;
        this.targetType = ClassUtils.isAssignable(databaseType, target.getClass()) ? databaseType : collectionType;
        this.sessionType = sessionType;
    }

    public @Nullable Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (this.requiresDecoration(methodInvocation.getMethod())) {
            Object target = methodInvocation.proceed();
            Assert.notNull((Object)target, (String)"invocation target was null");
            if (target instanceof Proxy) {
                return target;
            }
            return this.decorate(target);
        }
        if (!SessionAwareMethodInterceptor.requiresSession(methodInvocation.getMethod())) {
            return methodInvocation.proceed();
        }
        Optional<Method> targetMethod = METHOD_CACHE.lookup(methodInvocation.getMethod(), this.targetType, this.sessionType);
        return !targetMethod.isPresent() ? methodInvocation.proceed() : ReflectionUtils.invokeMethod((Method)targetMethod.get(), (Object)this.target, (Object[])SessionAwareMethodInterceptor.prependSessionToArguments(this.session, methodInvocation));
    }

    private boolean requiresDecoration(Method method) {
        return ClassUtils.isAssignable(this.databaseType, method.getReturnType()) || ClassUtils.isAssignable(this.collectionType, method.getReturnType());
    }

    protected Object decorate(Object target) {
        return ClassUtils.isAssignable(this.databaseType, target.getClass()) ? this.databaseDecorator.apply(this.session, target) : this.collectionDecorator.apply(this.session, target);
    }

    private static boolean requiresSession(Method method) {
        return method.getParameterCount() == 0 || !ClassUtils.isAssignable(ClientSession.class, method.getParameterTypes()[0]);
    }

    private static Object[] prependSessionToArguments(ClientSession session, MethodInvocation invocation) {
        Object[] args = new Object[invocation.getArguments().length + 1];
        args[0] = session;
        System.arraycopy(invocation.getArguments(), 0, args, 1, invocation.getArguments().length);
        return args;
    }

    public static interface ClientSessionOperator<T>
    extends BiFunction<ClientSession, T, T> {
    }

    static class MethodCache {
        private final ConcurrentReferenceHashMap<MethodClassKey, Optional<Method>> cache = new ConcurrentReferenceHashMap();

        MethodCache() {
        }

        Optional<Method> lookup(Method method, Class<?> targetClass, Class<? extends ClientSession> sessionType) {
            return (Optional)this.cache.computeIfAbsent((Object)new MethodClassKey(method, targetClass), val -> Optional.ofNullable(this.findTargetWithSession(method, targetClass, sessionType)));
        }

        private @Nullable Method findTargetWithSession(Method sourceMethod, Class<?> targetType, Class<? extends ClientSession> sessionType) {
            Class<?>[] argTypes = sourceMethod.getParameterTypes();
            Class[] args = new Class[argTypes.length + 1];
            args[0] = sessionType;
            System.arraycopy(argTypes, 0, args, 1, argTypes.length);
            return ReflectionUtils.findMethod(targetType, (String)sourceMethod.getName(), (Class[])args);
        }

        boolean contains(Method method, Class<?> targetClass) {
            return this.cache.containsKey((Object)new MethodClassKey(method, targetClass));
        }
    }
}

