/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.util;

import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.mongodb.core.query.Query;

public class SliceUtils {
    public static <T> Slice<T> sliceResult(List<T> resultList, Pageable pageable) {
        boolean hasNext;
        boolean bl = hasNext = resultList.size() > pageable.getPageSize();
        if (hasNext) {
            resultList = resultList.subList(0, pageable.getPageSize());
        }
        return new SliceImpl(resultList, pageable, hasNext);
    }

    public static Query limitResult(Query query, Pageable pageable) {
        if (pageable.isUnpaged()) {
            return query;
        }
        Query target = Query.of(query);
        target.skip(pageable.getOffset());
        target.limit(pageable.getPageSize() + 1);
        return target;
    }
}

