/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.util.Set;
import org.bson.Document;
import org.springframework.core.Ordered;
import org.springframework.data.mongodb.core.mapping.event.BeanValidationDelegate;
import org.springframework.data.mongodb.core.mapping.event.ReactiveBeforeSaveCallback;
import reactor.core.publisher.Mono;

public class ReactiveValidatingEntityCallback
implements ReactiveBeforeSaveCallback<Object>,
Ordered {
    private final BeanValidationDelegate delegate;

    public ReactiveValidatingEntityCallback(Validator validator) {
        this.delegate = new BeanValidationDelegate(validator);
    }

    @Override
    public Mono<Object> onBeforeSave(Object entity, Document document, String collection) {
        Set<ConstraintViolation<Object>> violations = this.delegate.validate(entity);
        if (!violations.isEmpty()) {
            return Mono.error((Throwable)new ConstraintViolationException(violations));
        }
        return Mono.just((Object)entity);
    }

    public int getOrder() {
        return 100;
    }
}

