/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bson.Document;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.index.SearchIndexDefinition;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Contract;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class VectorIndex
implements SearchIndexDefinition {
    private final String name;
    private final List<SearchField> fields = new ArrayList<SearchField>();

    public VectorIndex(String name) {
        this.name = name;
    }

    @Contract(value="_ -> this")
    public VectorIndex addFilter(String path) {
        Assert.hasText((String)path, (String)"Path must not be null or empty");
        return this.addField(new VectorFilterField(path, "filter"));
    }

    @Contract(value="_, _ -> this")
    public VectorIndex addVector(String path, Consumer<VectorFieldBuilder> customizer) {
        Assert.hasText((String)path, (String)"Path must not be null or empty");
        VectorFieldBuilder builder = new VectorFieldBuilder(path, "vector");
        customizer.accept(builder);
        return this.addField(builder.build());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return "vectorSearch";
    }

    @Override
    public Document getDefinition(@Nullable TypeInformation<?> entity, @Nullable MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        MongoPersistentEntity persistentEntity = entity != null ? (mappingContext != null ? (MongoPersistentEntity)mappingContext.getPersistentEntity(entity) : null) : null;
        Document definition = new Document();
        ArrayList<Document> fields = new ArrayList<Document>();
        definition.put("fields", fields);
        for (SearchField field : this.fields) {
            Document filter = new Document("type", (Object)field.type());
            filter.put("path", (Object)this.resolvePath(field.path(), persistentEntity, mappingContext));
            if (field instanceof VectorIndexField) {
                VectorIndexField vif = (VectorIndexField)field;
                filter.put("numDimensions", (Object)vif.dimensions());
                filter.put("similarity", (Object)vif.similarity());
                if (StringUtils.hasText((String)vif.quantization)) {
                    filter.put("quantization", (Object)vif.quantization());
                }
            }
            fields.add(filter);
        }
        return definition;
    }

    @Contract(value="_ -> this")
    private VectorIndex addField(SearchField filterField) {
        this.fields.add(filterField);
        return this;
    }

    public String toString() {
        return "VectorIndex{name='" + this.name + "', fields=" + String.valueOf(this.fields) + ", type='" + this.getType() + "'}";
    }

    static VectorIndex of(Document document) {
        VectorIndex index = new VectorIndex(document.getString((Object)"name"));
        String definitionKey = document.containsKey((Object)"latestDefinition") ? "latestDefinition" : "definition";
        Document definition = (Document)document.get((Object)definitionKey, Document.class);
        for (Object entry : (List)definition.get((Object)"fields", List.class)) {
            if (!(entry instanceof Document)) continue;
            Document field = (Document)entry;
            if (field.get((Object)"type").equals("vector")) {
                index.addField(new VectorIndexField(field.getString((Object)"path"), "vector", field.getInteger((Object)"numDimensions"), field.getString((Object)"similarity"), field.getString((Object)"quantization")));
                continue;
            }
            index.addField(new VectorFilterField(field.getString((Object)"path"), "filter"));
        }
        return index;
    }

    private String resolvePath(String path, @Nullable MongoPersistentEntity<?> persistentEntity, @Nullable MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        if (persistentEntity == null || mappingContext == null) {
            return path;
        }
        QueryMapper.MetadataBackedField mbf = new QueryMapper.MetadataBackedField(path, persistentEntity, mappingContext);
        return mbf.getMappedKey();
    }

    record VectorFilterField(String path, String type) implements SearchField
    {
    }

    static interface SearchField {
        public String path();

        public String type();
    }

    public static class VectorFieldBuilder {
        private final String path;
        private final String type;
        private int dimensions;
        @Nullable
        private String similarity;
        @Nullable
        private String quantization;

        VectorFieldBuilder(String path, String type) {
            this.path = path;
            this.type = type;
        }

        @Contract(value="_ -> this")
        public VectorFieldBuilder dimensions(int dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        @Contract(value=" -> this")
        public VectorFieldBuilder cosine() {
            return this.similarity(SimilarityFunction.COSINE);
        }

        @Contract(value=" -> this")
        public VectorFieldBuilder euclidean() {
            return this.similarity(SimilarityFunction.EUCLIDEAN);
        }

        @Contract(value=" -> this")
        public VectorFieldBuilder dotProduct() {
            return this.similarity(SimilarityFunction.DOT_PRODUCT);
        }

        @Contract(value="_ -> this")
        public VectorFieldBuilder similarity(String similarity) {
            this.similarity = similarity;
            return this;
        }

        @Contract(value="_ -> this")
        public VectorFieldBuilder similarity(SimilarityFunction similarity) {
            return this.similarity(similarity.getFunctionName());
        }

        public VectorFieldBuilder quantization(String quantization) {
            this.quantization = quantization;
            return this;
        }

        public VectorFieldBuilder quantization(Quantization quantization) {
            return this.quantization(quantization.getQuantizationName());
        }

        VectorIndexField build() {
            return new VectorIndexField(this.path, this.type, this.dimensions, this.similarity, this.quantization);
        }
    }

    record VectorIndexField(String path, String type, int dimensions, @Nullable String similarity, @Nullable String quantization) implements SearchField
    {
    }

    public static enum Quantization {
        NONE("none"),
        SCALAR("scalar"),
        BINARY("binary");

        final String quantizationName;

        private Quantization(String quantizationName) {
            this.quantizationName = quantizationName;
        }

        public String getQuantizationName() {
            return this.quantizationName;
        }
    }

    public static enum SimilarityFunction {
        DOT_PRODUCT("dotProduct"),
        COSINE("cosine"),
        EUCLIDEAN("euclidean");

        final String functionName;

        private SimilarityFunction(String functionName) {
            this.functionName = functionName;
        }

        public String getFunctionName() {
            return this.functionName;
        }
    }
}

