/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.MongoClientSettings;
import com.mongodb.ReadPreference;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.expression.ReactiveValueEvaluationContextProvider;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.core.ReactiveFindOperation;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.ReactiveUpdateOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationUpdate;
import org.springframework.data.mongodb.core.query.BasicUpdate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.Update;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.DefaultSpELExpressionEvaluator;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.mongodb.repository.query.ReactiveMongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryExecution;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.mongodb.repository.query.StringAggregationOperation;
import org.springframework.data.mongodb.repository.query.ValueExpressionDelegateValueExpressionEvaluator;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public abstract class AbstractReactiveMongoQuery
implements RepositoryQuery {
    private final ReactiveMongoQueryMethod method;
    private final ReactiveMongoOperations operations;
    private final EntityInstantiators instantiators;
    private final ReactiveFindOperation.FindWithProjection<?> findOperationWithProjection;
    private final ReactiveUpdateOperation.ReactiveUpdate<?> updateOps;
    private final ValueExpressionDelegate valueExpressionDelegate;
    private final ReactiveValueEvaluationContextProvider valueEvaluationContextProvider;

    @Deprecated(since="4.4.0")
    public AbstractReactiveMongoQuery(ReactiveMongoQueryMethod method, ReactiveMongoOperations operations, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)((Object)method), (String)"MongoQueryMethod must not be null");
        Assert.notNull((Object)operations, (String)"ReactiveMongoOperations must not be null");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"ReactiveEvaluationContextExtension must not be null");
        this.method = method;
        this.operations = operations;
        this.instantiators = new EntityInstantiators();
        this.valueExpressionDelegate = new ValueExpressionDelegate(new QueryMethodValueEvaluationContextAccessor((Environment)new StandardEnvironment(), evaluationContextProvider.getEvaluationContextProvider()), ValueExpressionParser.create(() -> expressionParser));
        EntityMetadata metadata = method.getEntityInformation();
        Class type = metadata.getCollectionEntity().getType();
        this.findOperationWithProjection = operations.query(type);
        this.updateOps = operations.update(type);
        ValueEvaluationContextProvider valueContextProvider = this.valueExpressionDelegate.createValueContextProvider((Parameters)method.getParameters());
        Assert.isInstanceOf(ReactiveValueEvaluationContextProvider.class, (Object)valueContextProvider, (String)"ValueEvaluationContextProvider must be reactive");
        this.valueEvaluationContextProvider = (ReactiveValueEvaluationContextProvider)valueContextProvider;
    }

    public AbstractReactiveMongoQuery(ReactiveMongoQueryMethod method, ReactiveMongoOperations operations, ValueExpressionDelegate delegate) {
        Assert.notNull((Object)((Object)method), (String)"MongoQueryMethod must not be null");
        Assert.notNull((Object)operations, (String)"ReactiveMongoOperations must not be null");
        Assert.notNull((Object)delegate, (String)"ValueExpressionDelegate must not be null");
        this.method = method;
        this.operations = operations;
        this.instantiators = new EntityInstantiators();
        this.valueExpressionDelegate = delegate;
        EntityMetadata metadata = method.getEntityInformation();
        Class type = metadata.getCollectionEntity().getType();
        this.findOperationWithProjection = operations.query(type);
        this.updateOps = operations.update(type);
        ValueEvaluationContextProvider valueContextProvider = this.valueExpressionDelegate.createValueContextProvider((Parameters)method.getParameters());
        Assert.isInstanceOf(ReactiveValueEvaluationContextProvider.class, (Object)valueContextProvider, (String)"ValueEvaluationContextProvider must be reactive");
        this.valueEvaluationContextProvider = (ReactiveValueEvaluationContextProvider)valueContextProvider;
    }

    public MongoQueryMethod getQueryMethod() {
        return this.method;
    }

    public Publisher<Object> execute(Object[] parameters) {
        return this.method.hasReactiveWrapperParameter() ? this.executeDeferred(parameters) : this.execute(new MongoParametersParameterAccessor(this.method, parameters));
    }

    private Publisher<Object> executeDeferred(Object[] parameters) {
        ReactiveMongoParameterAccessor parameterAccessor = new ReactiveMongoParameterAccessor(this.method, parameters);
        return parameterAccessor.resolveParameters().flatMapMany(this::execute);
    }

    private Publisher<Object> execute(MongoParameterAccessor parameterAccessor) {
        ConvertingParameterAccessor accessor = new ConvertingParameterAccessor(this.operations.getConverter(), parameterAccessor);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Class typeToRead = processor.getReturnedType().getTypeToRead();
        return this.doExecute(this.method, processor, accessor, typeToRead);
    }

    protected Publisher<Object> doExecute(ReactiveMongoQueryMethod method, ResultProcessor processor, ConvertingParameterAccessor accessor, @Nullable Class<?> typeToRead) {
        return this.createQuery(accessor).flatMapMany(it -> {
            Query query = it;
            this.applyQueryMetaAttributesWhenPresent(query);
            query = this.applyAnnotatedDefaultSortIfPresent(query);
            query = this.applyAnnotatedCollationIfPresent(query, accessor);
            query = this.applyHintIfPresent(query);
            query = this.applyAnnotatedReadPreferenceIfPresent(query);
            ReactiveFindOperation.FindWithProjection<?> find = typeToRead == null ? this.findOperationWithProjection : this.findOperationWithProjection.as(typeToRead);
            String collection = method.getEntityInformation().getCollectionName();
            ReactiveMongoQueryExecution execution = this.getExecution(accessor, this.getResultProcessing(processor), find);
            return execution.execute(query, processor.getReturnedType().getDomainType(), collection);
        });
    }

    ReactiveMongoQueryExecution.ResultProcessingConverter getResultProcessing(ResultProcessor processor) {
        return new ReactiveMongoQueryExecution.ResultProcessingConverter(processor, this.operations, this.instantiators);
    }

    private ReactiveMongoQueryExecution getExecution(MongoParameterAccessor accessor, Converter<Object, Object> resultProcessing, ReactiveFindOperation.FindWithQuery<?> operation) {
        return new ReactiveMongoQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(accessor, operation), resultProcessing);
    }

    private ReactiveMongoQueryExecution getExecutionToWrap(MongoParameterAccessor accessor, ReactiveFindOperation.FindWithQuery<?> operation) {
        if (this.isDeleteQuery()) {
            return new ReactiveMongoQueryExecution.DeleteExecution(this.operations, this.method);
        }
        if (this.method.isModifyingQuery()) {
            if (this.isLimiting()) {
                throw new IllegalStateException(String.format("Update method must not be limiting; Offending method: %s", new Object[]{this.method}));
            }
            return new ReactiveMongoQueryExecution.UpdateExecution(this.updateOps, this.method, accessor, this.createUpdate(accessor));
        }
        if (this.method.isGeoNearQuery()) {
            return new ReactiveMongoQueryExecution.GeoNearExecution(this.operations, accessor, this.method.getReturnType());
        }
        if (this.isTailable(this.method)) {
            return (q, t, c) -> operation.matching(q.with(accessor.getPageable())).tail();
        }
        if (this.method.isCollectionQuery()) {
            return (q, t, c) -> operation.matching(q.with(accessor.getPageable())).all();
        }
        if (this.method.isScrollQuery()) {
            return (q, t, c) -> operation.matching(q.with(accessor.getPageable()).with(accessor.getSort())).scroll(accessor.getScrollPosition());
        }
        if (this.isCountQuery()) {
            return (q, t, c) -> operation.matching(q).count();
        }
        if (this.isExistsQuery()) {
            return (q, t, c) -> operation.matching(q).exists();
        }
        return (q, t, c) -> {
            ReactiveFindOperation.TerminatingFind find = operation.matching(q);
            if (this.isCountQuery()) {
                return find.count();
            }
            return this.isLimiting() ? find.first() : find.one();
        };
    }

    private boolean isTailable(MongoQueryMethod method) {
        return method.getTailableAnnotation() != null;
    }

    Query applyQueryMetaAttributesWhenPresent(Query query) {
        if (this.method.hasQueryMetaAttributes()) {
            query.setMeta(this.method.getQueryMetaAttributes());
        }
        return query;
    }

    Query applyAnnotatedDefaultSortIfPresent(Query query) {
        if (!this.method.hasAnnotatedSort()) {
            return query;
        }
        return QueryUtils.decorateSort(query, Document.parse((String)this.method.getAnnotatedSort()));
    }

    Query applyAnnotatedCollationIfPresent(Query query, ConvertingParameterAccessor accessor) {
        return QueryUtils.applyCollation(query, this.method.hasAnnotatedCollation() ? this.method.getAnnotatedCollation() : null, accessor, this.getValueExpressionEvaluator(accessor));
    }

    Query applyHintIfPresent(Query query) {
        if (!this.method.hasAnnotatedHint()) {
            return query;
        }
        return query.withHint(this.method.getAnnotatedHint());
    }

    private Query applyAnnotatedReadPreferenceIfPresent(Query query) {
        if (!this.method.hasAnnotatedReadPreference()) {
            return query;
        }
        return query.withReadPreference(ReadPreference.valueOf((String)this.method.getAnnotatedReadPreference()));
    }

    protected Mono<Query> createCountQuery(ConvertingParameterAccessor accessor) {
        return this.createQuery(accessor).map(this::applyQueryMetaAttributesWhenPresent);
    }

    protected Mono<UpdateDefinition> createUpdate(MongoParameterAccessor accessor) {
        if (accessor.getUpdate() != null) {
            return Mono.just((Object)accessor.getUpdate());
        }
        if (this.method.hasAnnotatedUpdate()) {
            Update updateSource = this.method.getUpdateSource();
            if (StringUtils.hasText((String)updateSource.update())) {
                String updateJson = updateSource.update();
                return this.getParameterBindingCodec().flatMap(codec -> this.expressionEvaluator(updateJson, accessor, (ParameterBindingDocumentCodec)codec).map(evaluator -> this.decode((Tuple2<ValueExpressionEvaluator, ParameterBindingDocumentCodec>)evaluator, updateJson, accessor, (ParameterBindingDocumentCodec)codec))).map(x$0 -> BasicUpdate.fromDocument(x$0, new String[0]));
            }
            if (!ObjectUtils.isEmpty((Object[])updateSource.pipeline())) {
                return this.parseAggregationPipeline(updateSource.pipeline(), accessor).map(AggregationUpdate::from);
            }
        }
        throw new IllegalStateException(String.format("No Update provided for method %s.", new Object[]{this.method}));
    }

    protected Mono<List<AggregationOperation>> parseAggregationPipeline(String[] pipeline, MongoParameterAccessor accessor) {
        return this.getCodecRegistry().map(ParameterBindingDocumentCodec::new).flatMap(codec -> {
            ArrayList<Mono<AggregationOperation>> stages = new ArrayList<Mono<AggregationOperation>>(pipeline.length);
            for (String source : pipeline) {
                stages.add(this.computePipelineStage(source, accessor, (ParameterBindingDocumentCodec)codec));
            }
            return Flux.concat(stages).collectList();
        });
    }

    private Mono<AggregationOperation> computePipelineStage(String source, MongoParameterAccessor accessor, ParameterBindingDocumentCodec codec) {
        return this.expressionEvaluator(source, accessor, codec).map(evaluator -> new StringAggregationOperation(source, this.getQueryMethod().getDomainClass(), bsonString -> this.decode((Tuple2<ValueExpressionEvaluator, ParameterBindingDocumentCodec>)evaluator, (String)bsonString, accessor, codec)));
    }

    private Mono<Tuple2<ValueExpressionEvaluator, ParameterBindingDocumentCodec>> expressionEvaluator(String source, MongoParameterAccessor accessor, ParameterBindingDocumentCodec codec) {
        ExpressionDependencies dependencies = codec.captureExpressionDependencies(source, arg_0 -> ((MongoParameterAccessor)accessor).getBindableValue(arg_0), this.valueExpressionDelegate.getValueExpressionParser());
        return this.getValueExpressionEvaluatorLater(dependencies, accessor).zipWith(Mono.just((Object)codec));
    }

    private Document decode(Tuple2<ValueExpressionEvaluator, ParameterBindingDocumentCodec> expressionEvaluator, String source, MongoParameterAccessor accessor, ParameterBindingDocumentCodec codec) {
        ParameterBindingContext bindingContext = new ParameterBindingContext(arg_0 -> ((MongoParameterAccessor)accessor).getBindableValue(arg_0), (ValueExpressionEvaluator)expressionEvaluator.getT1());
        return codec.decode(source, bindingContext);
    }

    protected Mono<ParameterBindingDocumentCodec> getParameterBindingCodec() {
        return this.getCodecRegistry().map(ParameterBindingDocumentCodec::new);
    }

    @Deprecated(since="4.4.0")
    protected Mono<SpELExpressionEvaluator> getSpelEvaluatorFor(ExpressionDependencies dependencies, MongoParameterAccessor accessor) {
        return this.valueEvaluationContextProvider.getEvaluationContextLater((Object)accessor.getValues(), dependencies).map(evaluationContext -> new DefaultSpELExpressionEvaluator((ExpressionParser)new SpelExpressionParser(), evaluationContext.getEvaluationContext())).defaultIfEmpty((Object)DefaultSpELExpressionEvaluator.unsupported());
    }

    ValueExpressionEvaluator getValueExpressionEvaluator(final MongoParameterAccessor accessor) {
        return new ValueExpressionEvaluator(){

            public <T> T evaluate(String expressionString) {
                ValueExpression expression = AbstractReactiveMongoQuery.this.valueExpressionDelegate.parse(expressionString);
                ValueEvaluationContext evaluationContext = AbstractReactiveMongoQuery.this.valueEvaluationContextProvider.getEvaluationContext((Object)accessor.getValues(), expression.getExpressionDependencies());
                return (T)expression.evaluate(evaluationContext);
            }
        };
    }

    protected Mono<ValueExpressionEvaluator> getValueExpressionEvaluatorLater(ExpressionDependencies dependencies, MongoParameterAccessor accessor) {
        return this.valueEvaluationContextProvider.getEvaluationContextLater((Object)accessor.getValues(), dependencies).map(evaluationContext -> new ValueExpressionDelegateValueExpressionEvaluator(this.valueExpressionDelegate, valueExpression -> evaluationContext));
    }

    protected Mono<CodecRegistry> getCodecRegistry() {
        return Mono.from(this.operations.execute((MongoDatabase db) -> Mono.just((Object)db.getCodecRegistry()))).defaultIfEmpty((Object)MongoClientSettings.getDefaultCodecRegistry());
    }

    protected abstract Mono<Query> createQuery(ConvertingParameterAccessor var1);

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isLimiting();
}

