/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.LocalDateTimeField;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.TemporalField;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.Temporal;
import java.util.HexFormat;
import java.util.Locale;
import java.util.function.BiFunction;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.jspecify.annotations.Nullable;
import org.springframework.data.core.PropertyPath;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.HqlBaseVisitor;
import org.springframework.data.jpa.repository.query.HqlLexer;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.JpaQueryEnhancer;
import org.springframework.util.Assert;

class HqlOrderExpressionVisitor
extends HqlBaseVisitor<Expression<?>> {
    private static final DateTimeFormatter DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().toFormatter();
    private static final DateTimeFormatter DATE_TIME_FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);
    private static final DateTimeFormatter DATE_TIME_FORMATTER_TIME = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ENGLISH);
    private static final String UNSUPPORTED_TEMPLATE = "We can't handle %s in an ORDER BY clause through JpaSort.unsafe(\u2026)";
    private final CriteriaBuilder cb;
    private final Path<?> from;
    private final BiFunction<From<?, ?>, PropertyPath, Expression<?>> expressionFactory;

    HqlOrderExpressionVisitor(CriteriaBuilder cb, Path<?> from, BiFunction<From<?, ?>, PropertyPath, Expression<?>> expressionFactory) {
        this.cb = cb;
        this.from = from;
        this.expressionFactory = expressionFactory;
    }

    Expression<?> createCriteriaExpression(Sort.Order jpaOrder) {
        String orderByProperty = jpaOrder.getProperty();
        HqlLexer lexer = new HqlLexer((CharStream)CharStreams.fromString((String)orderByProperty));
        HqlParser parser = new HqlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        JpaQueryEnhancer.configureParser(orderByProperty, "ORDER BY expression", lexer, parser);
        HqlParser.SortExpressionContext ctx = parser.sortExpression();
        if (ctx == null) {
            throw new IllegalArgumentException("No sort expression provided");
        }
        return this.visitRequired((ParseTree)ctx);
    }

    @Override
    @Nullable
    public Expression<?> visitSortExpression(HqlParser.SortExpressionContext ctx) {
        if (ctx.identifier() != null) {
            HqlParser.IdentifierContext identifier = ctx.identifier();
            return this.from.get(this.getString(identifier));
        }
        if (ctx.INTEGER_LITERAL() != null) {
            return this.cb.literal((Object)Integer.valueOf(ctx.INTEGER_LITERAL().getText()));
        }
        if (ctx.expression() != null) {
            return this.visitRequired((ParseTree)ctx.expression());
        }
        return null;
    }

    @Override
    public Expression<?> visitRelationalExpression(HqlParser.RelationalExpressionContext ctx) {
        String op;
        Expression left = this.visitRequired((ParseTree)ctx.expression(0));
        Expression right = this.visitRequired((ParseTree)ctx.expression(1));
        return switch (op = ctx.op.getText()) {
            case "=" -> this.cb.equal(left, right);
            case ">" -> this.cb.greaterThan(left, right);
            case ">=" -> this.cb.greaterThanOrEqualTo(left, right);
            case "<" -> this.cb.lessThan(left, right);
            case "<=" -> this.cb.lessThanOrEqualTo(left, right);
            case "!=", "<>", "^=" -> this.cb.notEqual(left, right);
            default -> throw new UnsupportedOperationException("Unsupported comparison operator: " + op);
        };
    }

    @Override
    public Expression<?> visitBetweenExpression(HqlParser.BetweenExpressionContext ctx) {
        Expression condition = this.visitRequired((ParseTree)ctx.expression(0));
        Expression lower = this.visitRequired((ParseTree)ctx.expression(1));
        Expression upper = this.visitRequired((ParseTree)ctx.expression(2));
        if (ctx.NOT() == null) {
            return this.cb.between(condition, lower, upper);
        }
        return this.cb.between(condition, lower, upper).not();
    }

    @Override
    public Expression<?> visitIsBooleanPredicate(HqlParser.IsBooleanPredicateContext ctx) {
        Expression condition = this.visitRequired((ParseTree)ctx.expression());
        if (ctx.NULL() != null) {
            if (ctx.NOT() == null) {
                return this.cb.isNull(condition);
            }
            return this.cb.isNotNull(condition);
        }
        if (ctx.EMPTY() != null) {
            if (ctx.NOT() == null) {
                return this.cb.isEmpty(condition);
            }
            return this.cb.isNotEmpty(condition);
        }
        if (ctx.TRUE() != null) {
            if (ctx.NOT() == null) {
                return this.cb.isTrue(condition);
            }
            return this.cb.isFalse(condition);
        }
        if (ctx.FALSE() != null) {
            if (ctx.NOT() == null) {
                return this.cb.isFalse(condition);
            }
            return this.cb.isTrue(condition);
        }
        return null;
    }

    @Override
    public Expression<?> visitStringPatternMatching(HqlParser.StringPatternMatchingContext ctx) {
        Expression<Character> escape;
        Expression condition = this.visitRequired((ParseTree)ctx.expression(0));
        Expression match = this.visitRequired((ParseTree)ctx.expression(1));
        Expression<Character> expression = escape = ctx.ESCAPE() != null ? this.charLiteralOf(ctx.ESCAPE()) : null;
        if (ctx.LIKE() != null) {
            if (ctx.NOT() == null) {
                return escape == null ? this.cb.like(condition, match) : this.cb.like(condition, match, escape);
            }
            return escape == null ? this.cb.notLike(condition, match) : this.cb.notLike(condition, match, escape);
        }
        if (ctx.ILIKE() != null && this.cb instanceof HibernateCriteriaBuilder) {
            HibernateCriteriaBuilder hcb = (HibernateCriteriaBuilder)this.cb;
            if (ctx.NOT() == null) {
                return escape == null ? hcb.ilike(condition, match) : hcb.ilike(condition, match, escape);
            }
            return escape == null ? hcb.notIlike(condition, match) : hcb.notIlike(condition, match, escape);
        }
        throw new UnsupportedOperationException("Unsupported string pattern: " + ctx.getText());
    }

    @Override
    public Expression<?> visitInExpression(HqlParser.InExpressionContext ctx) {
        if (ctx.inList().simplePath() != null) {
            throw new UnsupportedOperationException(String.format(UNSUPPORTED_TEMPLATE, "IN clause with ELEMENTS or INDICES argument"));
        }
        if (ctx.inList().subquery() != null) {
            throw new UnsupportedOperationException(String.format(UNSUPPORTED_TEMPLATE, "IN clause with a subquery"));
        }
        if (ctx.inList().parameter() != null) {
            throw new UnsupportedOperationException(String.format(UNSUPPORTED_TEMPLATE, "IN clause with a parameter"));
        }
        CriteriaBuilder.In in = this.cb.in((Expression)this.visit((ParseTree)ctx.expression()));
        ctx.inList().expressionOrPredicate().forEach(expressionOrPredicateContext -> {
            CriteriaBuilder.In in2 = in.value((Expression)this.visit((ParseTree)expressionOrPredicateContext));
        });
        if (ctx.NOT() == null) {
            return in;
        }
        return in.not();
    }

    @Override
    public Expression<?> visitGenericFunction(HqlParser.GenericFunctionContext ctx) {
        String functionName = ctx.genericFunctionName().getText();
        if (ctx.genericFunctionArguments() == null) {
            return this.cb.function(functionName, Object.class, new Expression[0]);
        }
        Expression[] arguments = (Expression[])ctx.genericFunctionArguments().expressionOrPredicate().stream().map(this::visitRequired).toArray(Expression[]::new);
        return this.cb.function(functionName, Object.class, arguments);
    }

    @Override
    public Expression<?> visitCastFunction(HqlParser.CastFunctionContext ctx) {
        throw new UnsupportedOperationException("Sorting using CAST ist not supported");
    }

    @Override
    public Expression<?> visitTreatedNavigablePath(HqlParser.TreatedNavigablePathContext ctx) {
        throw new UnsupportedOperationException("Sorting using TREAT ist not supported");
    }

    @Override
    public Expression<?> visitExtractFunction(HqlParser.ExtractFunctionContext ctx) {
        Expression expr = this.visitRequired((ParseTree)ctx.expression());
        TemporalField<?, ? extends Temporal> temporalField = ctx.extractField() != null ? this.getTemporalField(ctx.extractField()) : this.getTemporalField(ctx.datetimeField());
        return this.cb.extract(temporalField, expr);
    }

    private TemporalField<?, ? extends Temporal> getTemporalField(HqlParser.DatetimeFieldContext ctx) {
        if (ctx.YEAR() != null) {
            return LocalDateTimeField.YEAR;
        }
        if (ctx.MONTH() != null) {
            return LocalDateTimeField.MONTH;
        }
        if (ctx.QUARTER() != null) {
            return LocalDateTimeField.QUARTER;
        }
        if (ctx.WEEK() != null) {
            return LocalDateTimeField.WEEK;
        }
        if (ctx.DAY() != null) {
            return LocalDateTimeField.DAY;
        }
        if (ctx.HOUR() != null) {
            return LocalDateTimeField.HOUR;
        }
        if (ctx.MINUTE() != null) {
            return LocalDateTimeField.MINUTE;
        }
        if (ctx.SECOND() != null) {
            return LocalDateTimeField.SECOND;
        }
        throw new UnsupportedOperationException("Unsupported extract field: " + ctx.getText());
    }

    private TemporalField<?, ? extends Temporal> getTemporalField(HqlParser.ExtractFieldContext ctx) {
        if (ctx.dateOrTimeField() != null) {
            if (ctx.dateOrTimeField().DATE() != null) {
                return LocalDateTimeField.DATE;
            }
            if (ctx.dateOrTimeField().TIME() != null) {
                return LocalDateTimeField.DATE;
            }
        } else if (ctx.datetimeField() != null) {
            if (ctx.datetimeField().YEAR() != null) {
                return LocalDateTimeField.YEAR;
            }
            if (ctx.datetimeField().MONTH() != null) {
                return LocalDateTimeField.MONTH;
            }
            if (ctx.datetimeField().QUARTER() != null) {
                return LocalDateTimeField.QUARTER;
            }
            if (ctx.datetimeField().WEEK() != null) {
                return LocalDateTimeField.WEEK;
            }
            if (ctx.datetimeField().DAY() != null) {
                return LocalDateTimeField.DAY;
            }
            if (ctx.datetimeField().HOUR() != null) {
                return LocalDateTimeField.HOUR;
            }
            if (ctx.datetimeField().MINUTE() != null) {
                return LocalDateTimeField.MINUTE;
            }
            if (ctx.datetimeField().SECOND() != null) {
                return LocalDateTimeField.SECOND;
            }
        } else if (ctx.weekField() != null) {
            if (ctx.weekField().WEEK() != null) {
                return LocalDateTimeField.WEEK;
            }
            if (ctx.weekField().MONTH() != null) {
                return LocalDateTimeField.MONTH;
            }
            if (ctx.weekField().YEAR() != null) {
                return LocalDateTimeField.YEAR;
            }
        }
        throw new UnsupportedOperationException("Unsupported extract field: " + ctx.getText());
    }

    @Override
    public Expression<?> visitTruncFunction(HqlParser.TruncFunctionContext ctx) {
        Expression expr = this.visitRequired((ParseTree)ctx.expression().get(0));
        if (ctx.datetimeField() != null) {
            TemporalField<?, ? extends Temporal> temporalField = this.getTemporalField(ctx.datetimeField());
            return this.cb.function("trunc", Object.class, new Expression[]{expr, this.cb.literal(temporalField)});
        }
        if (ctx.expression().size() > 1) {
            return this.cb.function("trunc", Object.class, new Expression[]{expr, this.visitRequired((ParseTree)ctx.expression().get(1))});
        }
        return this.cb.function("trunc", Object.class, new Expression[]{expr});
    }

    @Override
    public Expression<?> visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        CriteriaBuilder.Trimspec trimSpec = null;
        HqlParser.TrimSpecificationContext tsc = ctx.trimSpecification();
        if (tsc.LEADING() != null) {
            trimSpec = CriteriaBuilder.Trimspec.LEADING;
        } else if (tsc.TRAILING() != null) {
            trimSpec = CriteriaBuilder.Trimspec.TRAILING;
        } else if (tsc.BOTH() != null) {
            trimSpec = CriteriaBuilder.Trimspec.BOTH;
        }
        Expression<Character> stringLiteral = this.charLiteralOf(ctx.trimCharacter().STRING_LITERAL());
        Expression expression = this.visitRequired((ParseTree)ctx.expression());
        if (trimSpec != null) {
            return stringLiteral != null ? this.cb.trim(trimSpec, stringLiteral, expression) : this.cb.trim(trimSpec, expression);
        }
        return stringLiteral != null ? this.cb.trim(stringLiteral, expression) : this.cb.trim(expression);
    }

    @Override
    public Expression<?> visitSubstringFunction(HqlParser.SubstringFunctionContext ctx) {
        Expression start = this.visitRequired((ParseTree)ctx.substringFunctionStartArgument().expression());
        if (ctx.substringFunctionLengthArgument() != null) {
            Expression length = this.visitRequired((ParseTree)ctx.substringFunctionLengthArgument().expression());
            return this.cb.substring(this.visitRequired((ParseTree)ctx.expression()), start, length);
        }
        return this.cb.substring(this.visitRequired((ParseTree)ctx.expression()), start);
    }

    @Override
    public Expression<?> visitLiteral(HqlParser.LiteralContext ctx) {
        if (ctx.booleanLiteral() != null) {
            return this.visitRequired((ParseTree)ctx.booleanLiteral());
        }
        if (ctx.JAVA_STRING_LITERAL() != null) {
            return this.literalOf(ctx.JAVA_STRING_LITERAL());
        }
        if (ctx.STRING_LITERAL() != null) {
            return this.literalOf(ctx.STRING_LITERAL());
        }
        if (ctx.numericLiteral() != null) {
            return this.visitRequired((ParseTree)ctx.numericLiteral());
        }
        if (ctx.temporalLiteral() != null) {
            return this.visitRequired((ParseTree)ctx.temporalLiteral());
        }
        if (ctx.binaryLiteral() != null) {
            return this.visitRequired((ParseTree)ctx.binaryLiteral());
        }
        return null;
    }

    private Expression<String> literalOf(TerminalNode node) {
        String text = node.getText();
        return this.cb.literal((Object)HqlOrderExpressionVisitor.unquoteStringLiteral(text));
    }

    private Expression<Character> charLiteralOf(TerminalNode node) {
        String text = node.getText();
        return this.cb.literal((Object)Character.valueOf(text.charAt(0)));
    }

    @Override
    public Expression<?> visitBooleanLiteral(HqlParser.BooleanLiteralContext ctx) {
        if (ctx.TRUE() != null) {
            return this.cb.literal((Object)true);
        }
        return this.cb.literal((Object)false);
    }

    @Override
    public Expression<?> visitNumericLiteral(HqlParser.NumericLiteralContext ctx) {
        return this.cb.literal((Object)this.getLiteralValue(ctx));
    }

    private Number getLiteralValue(HqlParser.NumericLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return Integer.valueOf(HqlOrderExpressionVisitor.getDecimals(ctx.INTEGER_LITERAL()));
        }
        if (ctx.LONG_LITERAL() != null) {
            return Long.valueOf(HqlOrderExpressionVisitor.getDecimals(ctx.LONG_LITERAL()));
        }
        if (ctx.FLOAT_LITERAL() != null) {
            return Float.valueOf(HqlOrderExpressionVisitor.getDecimals(ctx.FLOAT_LITERAL()));
        }
        if (ctx.DOUBLE_LITERAL() != null) {
            return Double.valueOf(HqlOrderExpressionVisitor.getDecimals(ctx.DOUBLE_LITERAL()));
        }
        if (ctx.BIG_INTEGER_LITERAL() != null) {
            return new BigInteger(HqlOrderExpressionVisitor.getDecimals(ctx.BIG_INTEGER_LITERAL()));
        }
        if (ctx.BIG_DECIMAL_LITERAL() != null) {
            return new BigDecimal(HqlOrderExpressionVisitor.getDecimals(ctx.BIG_DECIMAL_LITERAL()));
        }
        if (ctx.HEX_LITERAL() != null) {
            return HexFormat.fromHexDigits(ctx.HEX_LITERAL().toString().substring(2));
        }
        throw new UnsupportedOperationException("Unsupported literal: " + ctx.getText());
    }

    @Override
    public Expression<?> visitDateTimeLiteral(HqlParser.DateTimeLiteralContext ctx) {
        if (ctx.offsetDateTimeLiteral() != null) {
            return (Expression)this.visit((ParseTree)ctx.offsetDateTimeLiteral());
        }
        if (ctx.localDateTimeLiteral() != null) {
            return (Expression)this.visit((ParseTree)ctx.localDateTimeLiteral());
        }
        if (ctx.zonedDateTimeLiteral() != null) {
            return (Expression)this.visit((ParseTree)ctx.zonedDateTimeLiteral());
        }
        return null;
    }

    @Override
    public Expression<?> visitJdbcTimeLiteral(HqlParser.JdbcTimeLiteralContext ctx) {
        if (ctx.time() != null) {
            return this.visitRequired((ParseTree)ctx.time());
        }
        return this.cb.literal((Object)DATE_TIME_FORMATTER_TIME.parse(HqlOrderExpressionVisitor.unquoteTemporal((ParseTree)ctx.genericTemporalLiteralText())));
    }

    @Override
    public Expression<?> visitDate(HqlParser.DateContext ctx) {
        return this.cb.literal((Object)LocalDate.from(DATE_TIME_FORMATTER_DATE.parse(HqlOrderExpressionVisitor.unquoteTemporal((ParseTree)ctx))));
    }

    @Override
    public Expression<?> visitTime(HqlParser.TimeContext ctx) {
        return this.cb.literal((Object)LocalTime.from(DATE_TIME_FORMATTER_TIME.parse(HqlOrderExpressionVisitor.unquoteTemporal((ParseTree)ctx))));
    }

    @Override
    public Expression<?> visitJdbcDateLiteral(HqlParser.JdbcDateLiteralContext ctx) {
        if (ctx.date() != null) {
            return this.visitRequired((ParseTree)ctx.date());
        }
        return this.cb.literal((Object)LocalDate.from(DATE_TIME_FORMATTER_DATE.parse(HqlOrderExpressionVisitor.unquoteTemporal((ParseTree)ctx.genericTemporalLiteralText()))));
    }

    @Override
    public Expression<?> visitJdbcTimestampLiteral(HqlParser.JdbcTimestampLiteralContext ctx) {
        if (ctx.dateTime() != null) {
            return this.visitRequired((ParseTree)ctx.dateTime());
        }
        return this.cb.literal((Object)LocalDateTime.from(DATE_TIME.parse(HqlOrderExpressionVisitor.unquoteTemporal((ParseTree)ctx.genericTemporalLiteralText()))));
    }

    @Override
    public Expression<?> visitLocalDateTime(HqlParser.LocalDateTimeContext ctx) {
        return this.cb.literal((Object)LocalDateTime.from(DATE_TIME.parse(HqlOrderExpressionVisitor.unquoteTemporal(ctx.getText()))));
    }

    @Override
    public Expression<?> visitZonedDateTime(HqlParser.ZonedDateTimeContext ctx) {
        return this.cb.literal((Object)ZonedDateTime.parse(ctx.getText()));
    }

    @Override
    public Expression<?> visitOffsetDateTime(HqlParser.OffsetDateTimeContext ctx) {
        return this.cb.literal((Object)OffsetDateTime.parse(ctx.getText()));
    }

    @Override
    public Expression<?> visitOffsetDateTimeWithMinutes(HqlParser.OffsetDateTimeWithMinutesContext ctx) {
        return this.cb.literal((Object)OffsetDateTime.parse(ctx.getText()));
    }

    @Override
    public Expression<?> visitLocalDateTimeLiteral(HqlParser.LocalDateTimeLiteralContext ctx) {
        return this.visitRequired((ParseTree)ctx.localDateTime());
    }

    @Override
    public Expression<?> visitZonedDateTimeLiteral(HqlParser.ZonedDateTimeLiteralContext ctx) {
        return this.visitRequired((ParseTree)ctx.zonedDateTime());
    }

    @Override
    public Expression<?> visitOffsetDateTimeLiteral(HqlParser.OffsetDateTimeLiteralContext ctx) {
        return this.visitRequired((ParseTree)(ctx.offsetDateTime() != null ? ctx.offsetDateTime() : ctx.offsetDateTimeWithMinutes()));
    }

    @Override
    public Expression<?> visitDateLiteral(HqlParser.DateLiteralContext ctx) {
        return this.visitRequired((ParseTree)ctx.date());
    }

    @Override
    public Expression<?> visitTimeLiteral(HqlParser.TimeLiteralContext ctx) {
        return this.visitRequired((ParseTree)ctx.time());
    }

    @Override
    public Expression<?> visitDateTime(HqlParser.DateTimeContext ctx) {
        return (Expression)super.visitDateTime(ctx);
    }

    @Override
    public Expression<?> visitGroupedExpression(HqlParser.GroupedExpressionContext ctx) {
        return (Expression)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public Expression<?> visitTupleExpression(HqlParser.TupleExpressionContext ctx) {
        return (Expression)this.cb.tuple((Selection[])ctx.expressionOrPredicate().stream().map(this::visitRequired).toArray(Expression[]::new));
    }

    @Override
    public Expression<?> visitSubqueryExpression(HqlParser.SubqueryExpressionContext ctx) {
        throw new UnsupportedOperationException(String.format(UNSUPPORTED_TEMPLATE, "a subquery argument"));
    }

    @Override
    public Expression<?> visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx) {
        Expression left = this.visitRequired((ParseTree)ctx.expression(0));
        Expression right = this.visitRequired((ParseTree)ctx.expression(1));
        if (ctx.op.getText().equals("*")) {
            return this.cb.prod(left, right);
        }
        return this.cb.quot(left, right);
    }

    @Override
    public Expression<?> visitAdditionExpression(HqlParser.AdditionExpressionContext ctx) {
        Expression left = this.visitRequired((ParseTree)ctx.expression(0));
        Expression right = this.visitRequired((ParseTree)ctx.expression(1));
        if (ctx.op.getText().equals("+")) {
            return this.cb.sum(left, right);
        }
        return this.cb.diff(left, right);
    }

    @Override
    public Expression<?> visitHqlConcatenationExpression(HqlParser.HqlConcatenationExpressionContext ctx) {
        Expression left = this.visitRequired((ParseTree)ctx.expression(0));
        Expression right = this.visitRequired((ParseTree)ctx.expression(1));
        return this.cb.concat(left, right);
    }

    @Override
    public Expression<?> visitSimplePath(HqlParser.SimplePathContext ctx) {
        return this.expressionFactory.apply((From)this.from, PropertyPath.from((String)ctx.getText(), (Class)this.from.getJavaType()));
    }

    @Override
    public Expression<?> visitCaseList(HqlParser.CaseListContext ctx) {
        return (Expression)this.visit((ParseTree)(ctx.simpleCaseExpression() != null ? ctx.simpleCaseExpression() : ctx.searchedCaseExpression()));
    }

    @Override
    public Expression<?> visitSimpleCaseExpression(HqlParser.SimpleCaseExpressionContext ctx) {
        CriteriaBuilder.SimpleCase simpleCase = this.cb.selectCase((Expression)this.visit((ParseTree)ctx.expressionOrPredicate(0)));
        ctx.caseWhenExpressionClause().forEach(caseWhenExpressionClauseContext -> simpleCase.when(this.visitRequired((ParseTree)caseWhenExpressionClauseContext.expression()), this.visitRequired((ParseTree)caseWhenExpressionClauseContext.expressionOrPredicate())));
        if (ctx.expressionOrPredicate().size() == 2) {
            simpleCase.otherwise(this.visitRequired((ParseTree)ctx.expressionOrPredicate(1)));
        }
        return simpleCase;
    }

    @Override
    public Expression<?> visitSearchedCaseExpression(HqlParser.SearchedCaseExpressionContext ctx) {
        CriteriaBuilder.Case searchedCase = this.cb.selectCase();
        ctx.caseWhenPredicateClause().forEach(caseWhenPredicateClauseContext -> searchedCase.when(this.visitRequired((ParseTree)caseWhenPredicateClauseContext.predicate()), (Expression)this.visit((ParseTree)caseWhenPredicateClauseContext.expressionOrPredicate())));
        if (ctx.expressionOrPredicate() != null) {
            searchedCase.otherwise((Expression)this.visit((ParseTree)ctx.expressionOrPredicate()));
        }
        return searchedCase;
    }

    @Override
    public Expression<?> visitParameter(HqlParser.ParameterContext ctx) {
        throw new UnsupportedOperationException(String.format(UNSUPPORTED_TEMPLATE, "a parameter argument"));
    }

    private <T> Expression<T> visitRequired(ParseTree ctx) {
        Expression expression = (Expression)this.visit(ctx);
        if (expression == null) {
            throw new UnsupportedOperationException("No result for expression: " + ctx.getText());
        }
        return expression;
    }

    private String getString(HqlParser.IdentifierContext context) {
        HqlParser.NakedIdentifierContext ni = context.nakedIdentifier();
        String text = context.getText();
        if (ni != null && ni.QUOTED_IDENTIFIER() != null) {
            text = HqlOrderExpressionVisitor.unquoteIdentifier(ni.getText());
        }
        return text;
    }

    private static String getDecimals(TerminalNode input) {
        String text = input.getText();
        StringBuilder result = new StringBuilder(text.length());
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (Character.isDigit(c) || c == '-' || c == '+' || c == '.') {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private static String unquoteTemporal(ParseTree node) {
        return HqlOrderExpressionVisitor.unquoteTemporal(node.getText());
    }

    private static String unquoteTemporal(String temporal) {
        if (temporal.startsWith("'") && temporal.endsWith("'")) {
            temporal = temporal.substring(1, temporal.length() - 1);
        }
        return temporal;
    }

    private static String unquoteIdentifier(String text) {
        int end = text.length() - 1;
        Assert.isTrue((text.charAt(0) == '`' && text.charAt(end) == '`' ? 1 : 0) != 0, (String)"Quoted identifier does not end with the same delimiter");
        StringBuilder sb = new StringBuilder(text.length() - 2);
        int i = 1;
        while (i < end) {
            int c = text.charAt(i);
            if (c == 92 && i + 1 < end) {
                char nextChar = text.charAt(++i);
                switch (nextChar) {
                    case 'b': {
                        c = 8;
                        break;
                    }
                    case 't': {
                        c = 9;
                        break;
                    }
                    case 'n': {
                        c = 10;
                        break;
                    }
                    case 'f': {
                        c = 12;
                        break;
                    }
                    case 'r': {
                        c = 13;
                        break;
                    }
                    case '\\': {
                        c = 92;
                        break;
                    }
                    case '\'': {
                        c = 39;
                        break;
                    }
                    case '\"': {
                        c = 34;
                        break;
                    }
                    case '`': {
                        c = 96;
                        break;
                    }
                    case 'u': {
                        c = (char)Integer.parseInt(text.substring(i + 1, i + 5), 16);
                        i += 4;
                        break;
                    }
                    default: {
                        sb.append('\\');
                        c = nextChar;
                    }
                }
            }
            sb.append((char)c);
            ++i;
        }
        return sb.toString();
    }

    private static String unquoteStringLiteral(String text) {
        int end = text.length() - 1;
        char delimiter = text.charAt(0);
        Assert.isTrue((delimiter == text.charAt(end) ? 1 : 0) != 0, (String)"Quoted identifier does not end with the same delimiter");
        StringBuilder sb = new StringBuilder(text.length() - 2);
        int i = 1;
        while (i < end) {
            char c = text.charAt(i);
            switch (c) {
                case '\'': {
                    if (delimiter != '\'') break;
                    ++i;
                    break;
                }
                case '\"': {
                    if (delimiter != '\"') break;
                    ++i;
                    break;
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }
}

