/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import org.springframework.data.jdbc.repository.query.EscapingParameterSource;
import org.springframework.data.relational.core.dialect.Escaper;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ParametrizedQuery {
    private final String query;
    private final SqlParameterSource parameterSource;
    private final Criteria criteria;

    ParametrizedQuery(String query, SqlParameterSource parameterSource, Criteria criteria) {
        this.query = query;
        this.parameterSource = parameterSource;
        this.criteria = criteria;
    }

    public SqlParameterSource getParameterSource() {
        return this.parameterSource;
    }

    public String getQuery() {
        return this.query;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    SqlParameterSource getParameterSource(Escaper escaper) {
        return new EscapingParameterSource(this.parameterSource, escaper);
    }

    public String toString() {
        return this.query;
    }
}

