/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jdbc.repository.query.JdbcQueryExecution;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

public abstract class AbstractJdbcQuery
implements RepositoryQuery {
    private final JdbcQueryMethod queryMethod;
    private final NamedParameterJdbcOperations operations;

    AbstractJdbcQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations) {
        Assert.notNull((Object)((Object)queryMethod), (String)"Query method must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        this.queryMethod = queryMethod;
        this.operations = operations;
    }

    public JdbcQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    JdbcQueryExecution<?> createReadingQueryExecution(@Nullable ResultSetExtractor<?> extractor, Supplier<RowMapper<?>> rowMapper) {
        if (this.getQueryMethod().isCollectionQuery()) {
            return extractor != null ? this.createSingleReadingQueryExecution(extractor) : this.collectionQuery(rowMapper.get());
        }
        if (this.getQueryMethod().isStreamQuery()) {
            return extractor != null ? this.createSingleReadingQueryExecution(extractor) : this.streamQuery(rowMapper.get());
        }
        return extractor != null ? this.createSingleReadingQueryExecution(extractor) : this.singleObjectQuery(rowMapper.get());
    }

    JdbcQueryExecution<Object> createModifyingQueryExecutor() {
        return (query, parameters) -> {
            int updatedCount = this.operations.update(query, parameters);
            Class returnedObjectType = this.queryMethod.getReturnedObjectType();
            return returnedObjectType == Boolean.TYPE || returnedObjectType == Boolean.class ? (Comparable<Boolean>)Boolean.valueOf(updatedCount != 0) : (Comparable<Boolean>)Integer.valueOf(updatedCount);
        };
    }

    JdbcQueryExecution<Object> singleObjectQuery(RowMapper<?> rowMapper) {
        return (query, parameters) -> {
            try {
                return this.operations.queryForObject(query, parameters, rowMapper);
            }
            catch (EmptyResultDataAccessException e) {
                return null;
            }
        };
    }

    <T> JdbcQueryExecution<List<T>> collectionQuery(RowMapper<T> rowMapper) {
        return this.createSingleReadingQueryExecution((ResultSetExtractor<T>)new RowMapperResultSetExtractor(rowMapper));
    }

    protected Class<?> resolveTypeToRead(ResultProcessor resultProcessor) {
        ReturnedType returnedType = resultProcessor.getReturnedType();
        if (returnedType.getReturnedType().isAssignableFrom(returnedType.getDomainType())) {
            return returnedType.getDomainType();
        }
        return returnedType.isProjecting() && returnedType.getReturnedType().isInterface() ? returnedType.getDomainType() : returnedType.getReturnedType();
    }

    private <T> JdbcQueryExecution<Stream<T>> streamQuery(RowMapper<T> rowMapper) {
        return (query, parameters) -> this.operations.queryForStream(query, parameters, rowMapper);
    }

    private <T> JdbcQueryExecution<T> createSingleReadingQueryExecution(ResultSetExtractor<T> resultSetExtractor) {
        return (query, parameters) -> this.operations.query(query, parameters, resultSetExtractor);
    }
}

