/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.aot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcCustomConversions;
import org.springframework.data.jdbc.core.convert.JdbcTypeFactory;
import org.springframework.data.jdbc.core.convert.MappingJdbcConverter;
import org.springframework.data.jdbc.core.dialect.JdbcDialect;
import org.springframework.data.jdbc.repository.aot.AotQueries;
import org.springframework.data.jdbc.repository.aot.DerivedAotQuery;
import org.springframework.data.jdbc.repository.aot.PlaceholderAccessor;
import org.springframework.data.jdbc.repository.aot.StringAotQuery;
import org.springframework.data.jdbc.repository.config.JdbcRepositoryConfigExtension;
import org.springframework.data.jdbc.repository.query.JdbcCountQueryCreator;
import org.springframework.data.jdbc.repository.query.JdbcParameters;
import org.springframework.data.jdbc.repository.query.JdbcQueryCreator;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.ParameterBinding;
import org.springframework.data.jdbc.repository.query.ParametrizedQuery;
import org.springframework.data.jdbc.repository.query.Query;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.repository.query.ParameterMetadataProvider;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.config.PropertiesBasedNamedQueriesFactoryBean;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.PropertiesBasedNamedQueries;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.query.ValueExpressionQueryRewriter;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.StringUtils;

class QueriesFactory {
    private final JdbcConverter converter;
    private final JdbcDialect dialect;
    private final NamedQueries namedQueries;
    private final ValueExpressionDelegate delegate;

    public QueriesFactory(RepositoryConfigurationSource configurationSource, JdbcDialect dialect, RelationalMappingContext mappingContext, ClassLoader classLoader, ValueExpressionDelegate delegate) {
        this.converter = new MappingJdbcConverter(mappingContext, (identifier, path) -> List.of(), JdbcCustomConversions.of(dialect, List.of()), JdbcTypeFactory.unsupported());
        this.namedQueries = this.getNamedQueries(configurationSource, classLoader);
        this.dialect = dialect;
        this.delegate = delegate;
    }

    public NamedQueries getNamedQueries() {
        return this.namedQueries;
    }

    private NamedQueries getNamedQueries(@Nullable RepositoryConfigurationSource configSource, ClassLoader classLoader) {
        String location;
        String string = location = configSource != null ? (String)configSource.getNamedQueryLocation().orElse(null) : null;
        if (location == null) {
            location = new JdbcRepositoryConfigExtension().getDefaultNamedQueryLocation();
        }
        if (StringUtils.hasText((String)location)) {
            try {
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
                PropertiesBasedNamedQueriesFactoryBean factoryBean = new PropertiesBasedNamedQueriesFactoryBean();
                factoryBean.setLocations(resolver.getResources(location));
                factoryBean.afterPropertiesSet();
                return (NamedQueries)Objects.requireNonNull(factoryBean.getObject());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new PropertiesBasedNamedQueries(new Properties());
    }

    public AotQueries createQueries(RepositoryInformation repositoryInformation, ReturnedType returnedType, MergedAnnotation<Query> query, JdbcQueryMethod queryMethod) {
        if (query.isPresent() && StringUtils.hasText((String)query.getString("value"))) {
            return this.buildStringQuery(query.getString("value"), queryMethod);
        }
        String queryName = queryMethod.getNamedQueryName();
        if (this.hasNamedQuery(queryName)) {
            return this.buildNamedQuery(queryName, queryMethod);
        }
        return this.buildPartTreeQuery(repositoryInformation, returnedType, queryMethod);
    }

    private boolean hasNamedQuery(String queryName) {
        return this.namedQueries.hasQuery(queryName);
    }

    private AotQueries buildStringQuery(String queryString, JdbcQueryMethod queryMethod) {
        ValueExpressionQueryRewriter.ParsedQuery parsedQuery = this.parseQuery(queryString);
        List<ParameterBinding> bindings = this.getBindings(parsedQuery, queryMethod);
        StringAotQuery aotStringQuery = StringAotQuery.of(parsedQuery.getQueryString(), bindings);
        return AotQueries.create(aotStringQuery);
    }

    private AotQueries buildNamedQuery(String queryName, JdbcQueryMethod queryMethod) {
        String queryString = this.namedQueries.getQuery(queryName);
        ValueExpressionQueryRewriter.ParsedQuery parsedQuery = this.parseQuery(queryString);
        return AotQueries.create(StringAotQuery.named(queryName, queryString, this.getBindings(parsedQuery, queryMethod)));
    }

    private AotQueries buildPartTreeQuery(RepositoryInformation repositoryInformation, ReturnedType returnedType, JdbcQueryMethod queryMethod) {
        PartTree partTree = new PartTree(queryMethod.getName(), repositoryInformation.getDomainType());
        RelationalParametersParameterAccessor accessor = this.getAccessor(queryMethod);
        JdbcQueryCreator queryCreator = new JdbcQueryCreator(partTree, this.converter, this.dialect, queryMethod, (RelationalParameterAccessor)accessor, returnedType){

            protected ParameterMetadataProvider getParameterMetadataProvider(RelationalParameterAccessor accessor) {
                return new PlaceholderAccessor.CapturingParameterMetadataProvider(accessor);
            }
        };
        ParametrizedQuery query = (ParametrizedQuery)queryCreator.createQuery(Sort.unsorted());
        DerivedAotQuery aotQuery = new DerivedAotQuery(query, partTree, partTree.isCountProjection());
        if (queryMethod.isPageQuery()) {
            JdbcCountQueryCreator countQueryCreator = new JdbcCountQueryCreator(partTree, this.converter, this.dialect, queryMethod, (RelationalParameterAccessor)accessor, returnedType){

                protected ParameterMetadataProvider getParameterMetadataProvider(RelationalParameterAccessor accessor) {
                    return PlaceholderAccessor.metadata(accessor);
                }
            };
            ParametrizedQuery countQuery = (ParametrizedQuery)countQueryCreator.createQuery(Sort.unsorted());
            DerivedAotQuery aotCountQuery = new DerivedAotQuery(countQuery, partTree, true);
            return AotQueries.create(aotQuery, aotCountQuery);
        }
        return AotQueries.create(aotQuery);
    }

    private RelationalParametersParameterAccessor getAccessor(JdbcQueryMethod queryMethod) {
        JdbcParameters parameters = queryMethod.getParameters();
        Object[] parameterValues = new Object[parameters.getNumberOfParameters()];
        RelationalParameters bindable = (RelationalParameters)parameters.getBindableParameters();
        return PlaceholderAccessor.capture(queryMethod, parameterValues, parameters, bindable);
    }

    private ValueExpressionQueryRewriter.ParsedQuery parseQuery(String queryString) {
        ValueExpressionQueryRewriter.EvaluatingValueExpressionQueryRewriter rewriter = ValueExpressionQueryRewriter.of((ValueExpressionDelegate)this.delegate, (counter, expression) -> String.format("__$synthetic$__%d", counter + 1), String::concat);
        return rewriter.parse(queryString);
    }

    private List<ParameterBinding> getBindings(ValueExpressionQueryRewriter.ParsedQuery parsedQuery, JdbcQueryMethod queryMethod) {
        ArrayList<ParameterBinding> bindings = new ArrayList<ParameterBinding>();
        ((RelationalParameters)queryMethod.getParameters().getBindableParameters()).forEach(parameter -> bindings.add(ParameterBinding.of((Parameter)parameter)));
        parsedQuery.getParameterMap().forEach((name, expression) -> bindings.add(ParameterBinding.named(name, ParameterBinding.ParameterOrigin.ofExpression(expression))));
        return bindings;
    }
}

