/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.function.Function;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.util.Assert;

public class JdbcIdentifierBuilder {
    private Identifier identifier;

    private JdbcIdentifierBuilder(Identifier identifier) {
        this.identifier = identifier;
    }

    public static JdbcIdentifierBuilder empty() {
        return new JdbcIdentifierBuilder(Identifier.empty());
    }

    public static JdbcIdentifierBuilder forBackReferences(JdbcConverter converter, AggregatePath path, Function<AggregatePath, Object> valueProvider) {
        return new JdbcIdentifierBuilder(JdbcIdentifierBuilder.forBackReference(converter, path, Identifier.empty(), valueProvider));
    }

    public static Identifier forBackReference(JdbcConverter converter, AggregatePath path, Identifier defaultIdentifier, Function<AggregatePath, Object> valueProvider) {
        Identifier identifierToUse = defaultIdentifier;
        AggregatePath idDefiningParentPath = path.getIdDefiningParentPath();
        if (idDefiningParentPath.hasIdProperty()) {
            AggregatePath.ColumnInfos infos = path.getTableInfo().backReferenceColumnInfos();
            identifierToUse = (Identifier)infos.reduce((Object)Identifier.empty(), (ap, ci) -> {
                RelationalPersistentProperty property = ap.getRequiredLeafProperty();
                return Identifier.of(ci.name(), valueProvider.apply((AggregatePath)ap), converter.getColumnType(property));
            }, Identifier::withPart);
        }
        return identifierToUse;
    }

    public JdbcIdentifierBuilder withQualifier(AggregatePath path, Object value) {
        Assert.notNull((Object)path, (String)"Path must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        AggregatePath.TableInfo tableInfo = path.getTableInfo();
        this.identifier = this.identifier.withPart(tableInfo.getRequiredQualifierColumnInfo().name(), value, tableInfo.getRequiredQualifierColumnType());
        return this;
    }

    public Identifier build() {
        return this.identifier;
    }
}

