/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.PathToColumnMapping;
import org.springframework.data.jdbc.core.convert.QueryMapper;
import org.springframework.data.jdbc.core.convert.RowDocumentResultSetExtractor;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sqlgeneration.AliasFactory;
import org.springframework.data.relational.core.sqlgeneration.SingleQuerySqlGenerator;
import org.springframework.data.relational.core.sqlgeneration.SqlGenerator;
import org.springframework.data.relational.domain.RowDocument;
import org.springframework.data.util.Streamable;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

class AggregateReader
implements PathToColumnMapping {
    private final AliasFactory aliasFactory = new AliasFactory();
    private final SqlGenerator sqlGenerator;
    private final JdbcConverter converter;
    private final NamedParameterJdbcOperations jdbcTemplate;
    private final RowDocumentResultSetExtractor extractor;

    AggregateReader(Dialect dialect, JdbcConverter converter, NamedParameterJdbcOperations jdbcTemplate) {
        this.converter = converter;
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = new SingleQuerySqlGenerator(converter.getMappingContext(), this.aliasFactory, dialect);
        this.extractor = new RowDocumentResultSetExtractor(converter.getMappingContext(), this);
    }

    @Override
    public String column(AggregatePath path) {
        String alias = this.aliasFactory.getColumnAlias(path);
        if (alias == null) {
            throw new IllegalStateException(String.format("Alias for '%s' must not be null", path));
        }
        return alias;
    }

    @Override
    public String keyColumn(AggregatePath path) {
        return this.aliasFactory.getKeyAlias(path);
    }

    public <T> @Nullable T findById(Object id, RelationalPersistentEntity<T> entity) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)((RelationalPersistentProperty)entity.getRequiredIdProperty()).getName()).is(id)).limit(1);
        return this.findOne(query, entity);
    }

    public <T> @Nullable T findOne(Query query, RelationalPersistentEntity<T> entity) {
        return (T)this.doFind(query, entity, rs -> this.extractZeroOrOne(rs, entity));
    }

    public <T> List<T> findAllById(Iterable<?> ids, RelationalPersistentEntity<T> entity) {
        Collection collection;
        if (ids instanceof Collection) {
            Collection idl = (Collection)ids;
            collection = idl;
        } else {
            collection = Streamable.of(ids).toList();
        }
        Collection identifiers = collection;
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)((RelationalPersistentProperty)entity.getRequiredIdProperty()).getName()).in(identifiers));
        return this.findAll(query, entity);
    }

    public <T> List<T> findAll(RelationalPersistentEntity<T> entity) {
        return (List)this.jdbcTemplate.query(this.sqlGenerator.findAll(entity), rs -> this.extractAll(rs, entity));
    }

    public <T> List<T> findAll(Query query, RelationalPersistentEntity<T> entity) {
        return (List)this.doFind(query, entity, rs -> this.extractAll(rs, entity));
    }

    private <T, R> R doFind(Query query, RelationalPersistentEntity<T> entity, ResultSetExtractor<R> extractor) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        Condition condition = this.createCondition(query, parameterSource, entity);
        String sql = this.sqlGenerator.findAll(entity, condition);
        return (R)this.jdbcTemplate.query(sql, (SqlParameterSource)parameterSource, extractor);
    }

    private @Nullable Condition createCondition(Query query, MapSqlParameterSource parameterSource, RelationalPersistentEntity<?> entity) {
        QueryMapper queryMapper = new QueryMapper(this.converter);
        Optional criteria = query.getCriteria();
        return criteria.map(criteriaDefinition -> queryMapper.getMappedObject(parameterSource, (CriteriaDefinition)criteriaDefinition, Table.create((SqlIdentifier)entity.getQualifiedTableName()), entity)).orElse(null);
    }

    private <T> List<T> extractAll(ResultSet rs, RelationalPersistentEntity<T> entity) throws SQLException {
        Iterator<RowDocument> iterate = this.extractor.iterate(entity, rs);
        ArrayList<Object> resultList = new ArrayList<Object>();
        while (iterate.hasNext()) {
            resultList.add(this.converter.read(entity.getType(), iterate.next()));
        }
        return resultList;
    }

    private <T> @Nullable T extractZeroOrOne(ResultSet rs, RelationalPersistentEntity<T> entity) throws SQLException {
        Iterator<RowDocument> iterate = this.extractor.iterate(entity, rs);
        if (iterate.hasNext()) {
            RowDocument object = iterate.next();
            if (iterate.hasNext()) {
                throw new IncorrectResultSizeDataAccessException(1);
            }
            return (T)this.converter.read(entity.getType(), object);
        }
        return null;
    }
}

