/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.support.DefaultStringObjectMap;
import org.springframework.data.mapping.MappingException;
import org.springframework.lang.Nullable;

class MapDocument
implements Document {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final DefaultStringObjectMap<?> documentAsMap;
    @Nullable
    private String index;
    @Nullable
    private String id;
    @Nullable
    private Long version;
    @Nullable
    private Long seqNo;
    @Nullable
    private Long primaryTerm;

    MapDocument() {
        this(new LinkedHashMap());
    }

    MapDocument(Map<String, ?> documentAsMap) {
        this.documentAsMap = new DefaultStringObjectMap(documentAsMap);
    }

    @Override
    public void setIndex(@Nullable String index) {
        this.index = index;
    }

    @Override
    @Nullable
    public String getIndex() {
        return this.index;
    }

    @Override
    public boolean hasId() {
        return this.id != null;
    }

    @Override
    public String getId() {
        if (!this.hasId()) {
            throw new IllegalStateException("No Id associated with this Document");
        }
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public long getVersion() {
        if (!this.hasVersion()) {
            throw new IllegalStateException("No version associated with this Document");
        }
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public boolean hasSeqNo() {
        return this.seqNo != null;
    }

    @Override
    public long getSeqNo() {
        if (!this.hasSeqNo()) {
            throw new IllegalStateException("No seq_no associated with this Document");
        }
        return this.seqNo;
    }

    @Override
    public void setSeqNo(long seqNo) {
        this.seqNo = seqNo;
    }

    @Override
    public boolean hasPrimaryTerm() {
        return this.primaryTerm != null;
    }

    @Override
    public long getPrimaryTerm() {
        if (!this.hasPrimaryTerm()) {
            throw new IllegalStateException("No primary_term associated with this Document");
        }
        return this.primaryTerm;
    }

    @Override
    public void setPrimaryTerm(long primaryTerm) {
        this.primaryTerm = primaryTerm;
    }

    @Override
    public int size() {
        return this.documentAsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.documentAsMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.documentAsMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.documentAsMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.documentAsMap.get(key);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.documentAsMap.getOrDefault(key, defaultValue);
    }

    @Override
    public Object put(String key, Object value) {
        return this.documentAsMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.documentAsMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.documentAsMap.putAll((Map<String, ?>)m);
    }

    @Override
    public void clear() {
        this.documentAsMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.documentAsMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.documentAsMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.documentAsMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.documentAsMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.documentAsMap.hashCode();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this.documentAsMap.forEach((BiConsumer<String, Object>)action);
    }

    @Override
    public String toJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new MappingException("Cannot render document to JSON", (Throwable)e);
        }
    }

    public String toString() {
        String id = this.hasId() ? this.getId() : "?";
        String version = this.hasVersion() ? Long.toString(this.getVersion()) : "?";
        return this.getClass().getSimpleName() + '@' + id + '#' + version + ' ' + this.toJson();
    }
}

