/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class PropertyAccessingMethodInterceptor
implements MethodInterceptor {
    private final BeanWrapper target;

    public PropertyAccessingMethodInterceptor(Object target) {
        Assert.notNull((Object)target, (String)"Proxy target must not be null");
        this.target = new DirectFieldAccessFallbackBeanWrapper(target);
    }

    public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
        if (ReflectionUtils.isObjectMethod((Method)invocation.getMethod())) {
            return invocation.proceed();
        }
        Method method = PropertyAccessingMethodInterceptor.lookupTargetMethod(invocation, this.target.getWrappedClass());
        PropertyDescriptor descriptor = BeanUtils.findPropertyForMethod((Method)method);
        if (descriptor == null) {
            throw new IllegalStateException("Invoked method '%s' is not a property accessor on '%s'".formatted(invocation.getMethod(), this.target.getWrappedClass().getName()));
        }
        if (!PropertyAccessingMethodInterceptor.isSetterMethod(method, descriptor)) {
            return this.target.getPropertyValue(descriptor.getName());
        }
        if (invocation.getArguments().length != 1) {
            throw new IllegalStateException("Invoked setter method requires exactly one argument");
        }
        this.target.setPropertyValue(descriptor.getName(), invocation.getArguments()[0]);
        return null;
    }

    private static boolean isSetterMethod(Method method, PropertyDescriptor descriptor) {
        return method.equals(descriptor.getWriteMethod());
    }

    private static Method lookupTargetMethod(MethodInvocation invocation, Class<?> targetType) {
        Method invokedMethod = invocation.getMethod();
        Method method = BeanUtils.findMethod(targetType, (String)invokedMethod.getName(), (Class[])invokedMethod.getParameterTypes());
        if (method == null) {
            return invokedMethod;
        }
        return BridgeMethodResolver.findBridgedMethod((Method)method);
    }
}

