/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.util.Arrays;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ClassGeneratingEntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.KotlinInstantiationDelegate;
import org.springframework.data.mapping.model.MappingInstantiationException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.util.KotlinReflectionUtils;

class KotlinClassGeneratingEntityInstantiator
extends ClassGeneratingEntityInstantiator {
    KotlinClassGeneratingEntityInstantiator() {
    }

    @Override
    protected EntityInstantiator doCreateEntityInstantiator(PersistentEntity<?, ?> entity) {
        PreferredConstructor constructor;
        KotlinInstantiationDelegate delegate;
        InstanceCreatorMetadata<?> creator = entity.getInstanceCreatorMetadata();
        if (KotlinReflectionUtils.isSupportedKotlinClass(entity.getType()) && creator instanceof PreferredConstructor && (delegate = KotlinInstantiationDelegate.resolve(constructor = (PreferredConstructor)creator)) != null) {
            ClassGeneratingEntityInstantiator.ObjectInstantiator instantiator = this.createObjectInstantiator(entity, delegate.getInstanceCreator());
            return new DefaultingKotlinClassInstantiatorAdapter(instantiator, delegate);
        }
        return super.doCreateEntityInstantiator(entity);
    }

    static class DefaultingKotlinClassInstantiatorAdapter
    implements EntityInstantiator {
        private final ClassGeneratingEntityInstantiator.ObjectInstantiator instantiator;
        private final KotlinInstantiationDelegate delegate;

        DefaultingKotlinClassInstantiatorAdapter(ClassGeneratingEntityInstantiator.ObjectInstantiator instantiator, KotlinInstantiationDelegate delegate) {
            this.instantiator = instantiator;
            this.delegate = delegate;
        }

        @Override
        public <T, E extends PersistentEntity<? extends T, P>, P extends PersistentProperty<P>> T createInstance(E entity, ParameterValueProvider<P> provider) {
            Object[] params = ClassGeneratingEntityInstantiator.allocateArguments(this.delegate.getRequiredParameterCount());
            this.delegate.extractInvocationArguments(params, entity.getInstanceCreatorMetadata(), provider);
            try {
                return (T)this.instantiator.newInstance(params);
            }
            catch (Exception e) {
                throw new MappingInstantiationException(entity, Arrays.asList(params), e);
            }
        }
    }
}

