/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import org.jspecify.annotations.Nullable;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.convert.ValueConverter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.Assert;

class AnnotatedPropertyValueConverterAccessor {
    private final String name;
    private final @Nullable ValueConverter annotation;

    public AnnotatedPropertyValueConverterAccessor(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null");
        this.name = property.toString();
        this.annotation = property.findAnnotation(ValueConverter.class);
    }

    public @Nullable Class<? extends PropertyValueConverter<?, ?, ? extends ValueConversionContext<? extends PersistentProperty<?>>>> getValueConverterType() {
        return this.annotation != null ? this.annotation.value() : null;
    }

    public Class<? extends PropertyValueConverter<?, ?, ? extends ValueConversionContext<? extends PersistentProperty<?>>>> getRequiredValueConverterType() throws IllegalStateException {
        Class<? extends PropertyValueConverter<?, ?, ? extends ValueConversionContext<? extends PersistentProperty<?>>>> converterType = this.getValueConverterType();
        if (converterType == null) {
            throw new IllegalStateException("No converter defined for property '" + this.name + "'");
        }
        return converterType;
    }

    public boolean hasValueConverter() {
        return this.annotation != null;
    }
}

