/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface FluentQuery<T> {
    public FluentQuery<T> sortBy(Sort var1);

    default public FluentQuery<T> limit(int limit) {
        throw new UnsupportedOperationException("Limit not supported");
    }

    public <R> FluentQuery<R> as(Class<R> var1);

    default public FluentQuery<T> project(String ... properties) {
        return this.project(Arrays.asList(properties));
    }

    public FluentQuery<T> project(Collection<String> var1);

    public static interface ReactiveFluentQuery<T>
    extends FluentQuery<T> {
        @Override
        public ReactiveFluentQuery<T> sortBy(Sort var1);

        @Override
        default public ReactiveFluentQuery<T> limit(int limit) {
            throw new UnsupportedOperationException("Limit not supported");
        }

        @Override
        public <R> ReactiveFluentQuery<R> as(Class<R> var1);

        @Override
        default public ReactiveFluentQuery<T> project(String ... properties) {
            return this.project(Arrays.asList(properties));
        }

        @Override
        public ReactiveFluentQuery<T> project(Collection<String> var1);

        public Mono<T> one();

        public Mono<T> first();

        public Flux<T> all();

        default public Mono<Window<T>> scroll(ScrollPosition scrollPosition) {
            throw new UnsupportedOperationException("Scrolling not supported");
        }

        public Mono<Page<T>> page(Pageable var1);

        default public Mono<Slice<T>> slice(Pageable pageable) {
            return this.page(pageable).map(Function.identity());
        }

        public Mono<Long> count();

        public Mono<Boolean> exists();
    }

    public static interface FetchableFluentQuery<T>
    extends FluentQuery<T> {
        @Override
        public FetchableFluentQuery<T> sortBy(Sort var1);

        @Override
        default public FetchableFluentQuery<T> limit(int limit) {
            throw new UnsupportedOperationException("Limit not supported");
        }

        @Override
        public <R> FetchableFluentQuery<R> as(Class<R> var1);

        @Override
        default public FetchableFluentQuery<T> project(String ... properties) {
            return this.project(Arrays.asList(properties));
        }

        @Override
        public FetchableFluentQuery<T> project(Collection<String> var1);

        default public Optional<T> one() {
            return Optional.ofNullable(this.oneValue());
        }

        @Nullable
        public T oneValue();

        default public Optional<T> first() {
            return Optional.ofNullable(this.firstValue());
        }

        @Nullable
        public T firstValue();

        public List<T> all();

        default public Window<T> scroll(ScrollPosition scrollPosition) {
            throw new UnsupportedOperationException("Scrolling not supported");
        }

        public Page<T> page(Pageable var1);

        default public Slice<T> slice(Pageable pageable) {
            return this.page(pageable);
        }

        public Stream<T> stream();

        public long count();

        public boolean exists();
    }
}

