/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.stream.function.FunctionConfiguration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

class VersionExtractor
implements EnvironmentPostProcessor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Pattern versionPattern = Pattern.compile("(\\d+)\\.{1}(\\d+)\\.{1}(\\d+)(?:\\-{1}(\\w+))?");

    VersionExtractor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String streamJarPath = FunctionConfiguration.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Spring Cloud Stream is loaded from: " + streamJarPath));
        }
        System.setProperty("spring-cloud-stream.version", this.extractVersion(streamJarPath));
        String functionJarPath = FunctionCatalog.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Spring Cloud Function is loaded from: " + streamJarPath));
        }
        System.setProperty("spring-cloud-function.version", this.extractVersion(functionJarPath));
    }

    private String extractVersion(String jarFilePath) {
        try {
            if (jarFilePath.endsWith(".jar")) {
                Matcher m = this.versionPattern.matcher(jarFilePath);
                if (!m.find()) {
                    return "";
                }
                StringBuilder versionBuilder = new StringBuilder();
                String delimiter = "";
                int i = 0;
                while (i < m.groupCount()) {
                    String value;
                    if (!StringUtils.hasText((String)(value = m.group(++i)))) continue;
                    versionBuilder.append(delimiter);
                    versionBuilder.append(value);
                    delimiter = i + 1 < m.groupCount() ? "." : "-";
                }
                return versionBuilder.toString();
            }
        }
        catch (Throwable e) {
            this.logger.warn((Object)("Failed to determine version of: " + jarFilePath), e);
        }
        return "";
    }
}

