/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit;

import com.rabbitmq.stream.Environment;
import java.util.Map;
import java.util.function.Function;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.ObservableListenerContainer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitConsumerProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.integration.amqp.inbound.AmqpInboundChannelAdapter;
import org.springframework.integration.amqp.outbound.RabbitStreamMessageHandler;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.rabbit.stream.listener.ConsumerCustomizer;
import org.springframework.rabbit.stream.listener.StreamListenerContainer;
import org.springframework.rabbit.stream.producer.RabbitStreamOperations;
import org.springframework.rabbit.stream.producer.RabbitStreamTemplate;
import org.springframework.rabbit.stream.support.StreamMessageProperties;
import org.springframework.rabbit.stream.support.converter.StreamMessageConverter;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static ObservableListenerContainer createContainer(final ConsumerDestination consumerDestination, final String group, final ExtendedConsumerProperties<RabbitConsumerProperties> properties, String destination, ApplicationContext applicationContext) {
        RabbitConsumerProperties extension = (RabbitConsumerProperties)properties.getExtension();
        StreamListenerContainer container = new StreamListenerContainer((Environment)applicationContext.getBean(Environment.class)){

            public synchronized void setConsumerCustomizer(ConsumerCustomizer consumerCustomizer) {
                super.setConsumerCustomizer((id, builder) -> {
                    if (!((RabbitConsumerProperties)properties.getExtension()).isSuperStream()) {
                        builder.name(consumerDestination.getName() + "." + group);
                    }
                    consumerCustomizer.accept(id, builder);
                });
            }
        };
        container.setBeanName(consumerDestination.getName() + "." + group + ".container");
        String beanName = extension.getStreamStreamMessageConverterBeanName();
        if (beanName != null) {
            container.setStreamConverter((StreamMessageConverter)applicationContext.getBean(beanName, StreamMessageConverter.class));
        }
        if (((RabbitConsumerProperties)properties.getExtension()).isSuperStream()) {
            container.superStream(consumerDestination.getName(), consumerDestination.getName() + "." + group, properties.getConcurrency());
        }
        return container;
    }

    public static void configureAdapter(AmqpInboundChannelAdapter adapter) {
        adapter.setHeaderMapper(new AmqpHeaderMapper(){
            AmqpHeaderMapper mapper = DefaultAmqpHeaderMapper.inboundMapper();

            public Map<String, Object> toHeadersFromRequest(MessageProperties source) {
                Map headers = this.mapper.toHeadersFromRequest((Object)source);
                headers.put("rabbitmq_streamContext", ((StreamMessageProperties)source).getContext());
                return headers;
            }

            public Map<String, Object> toHeadersFromReply(MessageProperties source) {
                return null;
            }

            public void fromHeadersToRequest(MessageHeaders headers, MessageProperties target) {
            }

            public void fromHeadersToReply(MessageHeaders headers, MessageProperties target) {
            }
        });
    }

    public static MessageHandler createStreamMessageHandler(ProducerDestination producerDestination, ExtendedProducerProperties<RabbitProducerProperties> producerProperties, MessageChannel errorChannel, String destination, RabbitProducerProperties extendedProperties, AbstractApplicationContext applicationContext, Function<RabbitProducerProperties, AmqpHeaderMapper> headerMapperFunction) {
        String beanName;
        RabbitStreamTemplate template = new RabbitStreamTemplate((Environment)applicationContext.getBean(Environment.class), producerDestination.getName());
        if (extendedProperties.isSuperStream()) {
            template.setSuperStreamRouting(message -> {
                String property = message.getApplicationProperties().getOrDefault("scst_partition", "0");
                message.getApplicationProperties().remove("scst_partition");
                return property;
            });
        }
        if ((beanName = extendedProperties.getStreamMessageConverterBeanName()) != null) {
            template.setMessageConverter((MessageConverter)applicationContext.getBean(beanName, MessageConverter.class));
        }
        if ((beanName = extendedProperties.getStreamStreamMessageConverterBeanName()) != null) {
            template.setStreamConverter((StreamMessageConverter)applicationContext.getBean(beanName, StreamMessageConverter.class));
        }
        RabbitStreamMessageHandler handler = new RabbitStreamMessageHandler((RabbitStreamOperations)template);
        handler.setApplicationContext((ApplicationContext)applicationContext);
        handler.setBeanFactory((BeanFactory)applicationContext.getBeanFactory());
        if (errorChannel != null) {
            handler.setSendFailureChannel(errorChannel);
        }
        if ((beanName = extendedProperties.getConfirmAckChannel()) != null) {
            handler.setSendSuccessChannelName(beanName);
        }
        handler.setHeaderMapper(headerMapperFunction.apply(extendedProperties));
        handler.setSync(RabbitProducerProperties.ProducerType.STREAM_SYNC.equals((Object)((RabbitProducerProperties)producerProperties.getExtension()).getProducerType()));
        return handler;
    }
}

