/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;

public class WebClientEurekaHttpClient
implements EurekaHttpClient {
    private final WebClient webClient;

    public WebClientEurekaHttpClient(WebClient webClient) {
        this.webClient = webClient;
    }

    public EurekaHttpResponse<Void> register(InstanceInfo info) {
        return (EurekaHttpResponse)((WebClient.RequestBodySpec)this.webClient.post().uri("apps/" + info.getAppName(), new Object[]{Void.class})).body(BodyInserters.fromValue((Object)info)).header("Accept-Encoding", new String[]{"gzip"}).header("Content-Type", new String[]{"application/json"}).exchange().map(response -> this.eurekaHttpResponse((ClientResponse)response)).block();
    }

    public EurekaHttpResponse<Void> cancel(String appName, String id) {
        return (EurekaHttpResponse)this.webClient.delete().uri("apps/" + appName + "/" + id, new Object[]{Void.class}).exchange().map(response -> this.eurekaHttpResponse((ClientResponse)response)).block();
    }

    public EurekaHttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        String urlPath = "apps/" + appName + "/" + id + "?status=" + info.getStatus().toString() + "&lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString() + (String)(overriddenStatus != null ? "&overriddenstatus=" + overriddenStatus.name() : "");
        ClientResponse response = (ClientResponse)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.put().uri(urlPath, new Object[]{InstanceInfo.class})).header("Content-Type", new String[]{"application/json"})).header("Accept", new String[]{"application/json"})).exchange().block();
        EurekaHttpResponse.EurekaHttpResponseBuilder builder = EurekaHttpResponse.anEurekaHttpResponse((int)this.statusCodeValueOf(response), InstanceInfo.class).headers(WebClientEurekaHttpClient.headersOf(response));
        InstanceInfo entity = (InstanceInfo)((ResponseEntity)response.toEntity(InstanceInfo.class).block()).getBody();
        if (entity != null) {
            builder.entity((Object)entity);
        }
        return builder.build();
    }

    public EurekaHttpResponse<Void> statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        String urlPath = "apps/" + appName + "/" + id + "/status?value=" + newStatus.name() + "&lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString();
        return (EurekaHttpResponse)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.put().uri(urlPath, new Object[]{Void.class})).header("Content-Type", new String[]{"application/json"})).exchange().map(response -> this.eurekaHttpResponse((ClientResponse)response)).block();
    }

    public EurekaHttpResponse<Void> deleteStatusOverride(String appName, String id, InstanceInfo info) {
        String urlPath = "apps/" + appName + "/" + id + "/status?lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString();
        return (EurekaHttpResponse)this.webClient.delete().uri(urlPath, new Object[]{Void.class}).header("Content-Type", new String[]{"application/json"}).exchange().map(response -> this.eurekaHttpResponse((ClientResponse)response)).block();
    }

    public EurekaHttpResponse<Applications> getApplications(String ... regions) {
        return this.getApplicationsInternal("apps/", regions);
    }

    private EurekaHttpResponse<Applications> getApplicationsInternal(String urlPath, String[] regions) {
        Object url = urlPath;
        if (regions != null && regions.length > 0) {
            url = (String)url + (urlPath.contains("?") ? "&" : "?") + "regions=" + StringUtil.join((String[])regions);
        }
        ClientResponse response = (ClientResponse)this.webClient.get().uri((String)url, new Object[]{Applications.class}).header("Content-Type", new String[]{"application/json"}).header("Accept", new String[]{"application/json"}).exchange().block();
        int statusCode = this.statusCodeValueOf(response);
        Applications body = (Applications)((ResponseEntity)response.toEntity(Applications.class).block()).getBody();
        return EurekaHttpResponse.anEurekaHttpResponse((int)statusCode, statusCode == HttpStatus.OK.value() && body != null ? body : null).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<Applications> getDelta(String ... regions) {
        return this.getApplicationsInternal("apps/delta", regions);
    }

    public EurekaHttpResponse<Applications> getVip(String vipAddress, String ... regions) {
        return this.getApplicationsInternal("vips/" + vipAddress, regions);
    }

    public EurekaHttpResponse<Applications> getSecureVip(String secureVipAddress, String ... regions) {
        return this.getApplicationsInternal("svips/" + secureVipAddress, regions);
    }

    public EurekaHttpResponse<Application> getApplication(String appName) {
        ClientResponse response = (ClientResponse)this.webClient.get().uri("apps/" + appName, new Object[]{Application.class}).header("Accept", new String[]{"application/json"}).exchange().block();
        int statusCode = this.statusCodeValueOf(response);
        Application body = (Application)((ResponseEntity)response.toEntity(Application.class).block()).getBody();
        Application application = statusCode == HttpStatus.OK.value() && body != null ? body : null;
        return EurekaHttpResponse.anEurekaHttpResponse((int)statusCode, (Object)application).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String appName, String id) {
        return this.getInstanceInternal("apps/" + appName + "/" + id);
    }

    public EurekaHttpResponse<InstanceInfo> getInstance(String id) {
        return this.getInstanceInternal("instances/" + id);
    }

    private EurekaHttpResponse<InstanceInfo> getInstanceInternal(String urlPath) {
        ClientResponse response = (ClientResponse)this.webClient.get().uri(urlPath, new Object[]{InstanceInfo.class}).header("Accept", new String[]{"application/json"}).exchange().block();
        int statusCode = this.statusCodeValueOf(response);
        InstanceInfo body = (InstanceInfo)((ResponseEntity)response.toEntity(InstanceInfo.class).block()).getBody();
        return EurekaHttpResponse.anEurekaHttpResponse((int)statusCode, statusCode == HttpStatus.OK.value() && body != null ? body : null).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }

    public void shutdown() {
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    private static Map<String, String> headersOf(ClientResponse response) {
        ClientResponse.Headers httpHeaders = response.headers();
        if (httpHeaders == null) {
            return Collections.emptyMap();
        }
        HttpHeaders asHeaders = httpHeaders.asHttpHeaders();
        if (asHeaders == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        asHeaders.entrySet().forEach(entry -> ((List)entry.getValue()).forEach(v -> headers.put((String)entry.getKey(), (String)v)));
        return headers;
    }

    private int statusCodeValueOf(ClientResponse response) {
        return response.statusCode().value();
    }

    private EurekaHttpResponse<Void> eurekaHttpResponse(ClientResponse response) {
        return EurekaHttpResponse.anEurekaHttpResponse((int)this.statusCodeValueOf(response)).headers(WebClientEurekaHttpClient.headersOf(response)).build();
    }
}

