/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8;

import io.fabric8.kubernetes.api.model.Pod;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.kubernetes.commons.AbstractKubernetesHealthIndicator;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.util.CollectionUtils;

public class Fabric8HealthIndicator
extends AbstractKubernetesHealthIndicator {
    private final PodUtils<Pod> utils;

    public Fabric8HealthIndicator(PodUtils<Pod> utils) {
        this.utils = utils;
    }

    protected Map<String, Object> getDetails() {
        Pod current = (Pod)this.utils.currentPod().get();
        if (current != null) {
            HashMap details = CollectionUtils.newHashMap((int)8);
            details.put("inside", true);
            details.put("namespace", current.getMetadata().getNamespace());
            details.put("podName", current.getMetadata().getName());
            details.put("labels", current.getMetadata().getLabels());
            details.put("podIp", current.getStatus().getPodIP());
            details.put("hostIp", current.getStatus().getHostIP());
            details.put("serviceAccount", current.getSpec().getServiceAccountName());
            details.put("nodeName", current.getSpec().getNodeName());
            return details;
        }
        return Collections.singletonMap("inside", false);
    }
}

