/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.invoke;

import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameter;
import org.springframework.util.StringUtils;

public final class MissingParametersException
extends RuntimeException {
    private final Set<OperationParameter> missingParameters;
    private final String reason;

    public MissingParametersException(Set<OperationParameter> missingParameters) {
        super("Failed to invoke operation because the following required parameters were missing: " + StringUtils.collectionToCommaDelimitedString(missingParameters));
        this.reason = "Missing parameters: " + missingParameters.stream().map(OperationParameter::getName).collect(Collectors.joining(","));
        this.missingParameters = missingParameters;
    }

    public Set<OperationParameter> getMissingParameters() {
        return this.missingParameters;
    }

    public String getReason() {
        return this.reason;
    }
}

