/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import org.springframework.cloud.gateway.server.mvc.filter.HttpHeadersFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.web.servlet.function.ServerRequest;

public class TransferEncodingNormalizationRequestHeadersFilter
implements HttpHeadersFilter.RequestHttpHeadersFilter,
Ordered {
    public int getOrder() {
        return 1000;
    }

    @Override
    public HttpHeaders apply(HttpHeaders input, ServerRequest request) {
        String transferEncoding = input.getFirst("Transfer-Encoding");
        if (transferEncoding != null && "chunked".equalsIgnoreCase(transferEncoding.trim()) && input.containsHeader("Content-Length")) {
            HttpHeaders filtered = new HttpHeaders();
            filtered.addAll(input);
            filtered.remove("Content-Length");
            return filtered;
        }
        return input;
    }
}

