/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class FunctionContextUtils {
    public static Type findType(String name, ConfigurableListableBeanFactory registry) {
        return FunctionContextUtils.findType(registry, name);
    }

    public static Type findType(ConfigurableListableBeanFactory registry, String ... names) {
        AbstractBeanDefinition definition = null;
        String actualName = null;
        for (String name : names) {
            if (registry.containsBeanDefinition(name)) {
                definition = (AbstractBeanDefinition)registry.getBeanDefinition(name);
                actualName = name;
                continue;
            }
            if (!registry.containsBean(name)) continue;
            return FunctionTypeUtils.discoverFunctionTypeFromClass(registry.getBean(name).getClass());
        }
        Class<?> beanClass = null;
        if (definition == null) {
            return null;
        }
        beanClass = FunctionContextUtils.resolveBeanClass(definition);
        Object source = definition.getSource();
        Type param = null;
        if (source instanceof MethodMetadata) {
            param = FunctionContextUtils.findBeanType(definition, ((MethodMetadata)source).getDeclaringClassName(), ((MethodMetadata)source).getMethodName());
        } else if (source instanceof Resource) {
            param = registry.getType(actualName);
        }
        if (param == null) {
            param = definition.getResolvableType().getType();
        }
        if (!(param instanceof ParameterizedType) && beanClass != null) {
            return FunctionTypeUtils.discoverFunctionTypeFromClass(beanClass);
        }
        return param;
    }

    public static Class<?>[] getParamTypesFromBeanDefinitionFactory(Class<?> factory, AbstractBeanDefinition definition, String methodName) {
        if (definition instanceof RootBeanDefinition) {
            RootBeanDefinition root = (RootBeanDefinition)definition;
            for (Method method : FunctionContextUtils.getCandidateMethods(factory, root)) {
                if (!method.getName().equals(methodName) || AnnotationUtils.findAnnotation((Method)method, Bean.class) == null) continue;
                return method.getParameterTypes();
            }
        }
        ArrayList<Class> params = new ArrayList<Class>();
        for (ConstructorArgumentValues.ValueHolder holder : definition.getConstructorArgumentValues().getIndexedArgumentValues().values()) {
            params.add(ClassUtils.resolveClassName((String)holder.getType(), null));
        }
        return params.toArray(new Class[0]);
    }

    private static Class<?> resolveBeanClass(AbstractBeanDefinition beanDefinition) {
        try {
            return beanDefinition.hasBeanClass() ? beanDefinition.getBeanClass() : ClassUtils.getDefaultClassLoader().loadClass(beanDefinition.getBeanClassName());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Type findBeanType(AbstractBeanDefinition definition, String declaringClassName, String methodName) {
        Class factory = ClassUtils.resolveClassName((String)declaringClassName, null);
        Class[] params = FunctionContextUtils.getParamTypesFromBeanDefinitionFactory(factory, definition, methodName);
        Method method = ReflectionUtils.findMethod((Class)factory, (String)methodName, (Class[])params);
        Type type = method.getGenericReturnType();
        return type;
    }

    private static Method[] getCandidateMethods(Class<?> factoryClass, RootBeanDefinition mbd) {
        return mbd.isNonPublicAccessAllowed() ? ReflectionUtils.getAllDeclaredMethods(factoryClass) : factoryClass.getMethods();
    }
}

