/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.dsl.task;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.dsl.task.Task;
import org.springframework.cloud.dataflow.rest.client.dsl.task.TaskSchedule;
import org.springframework.cloud.dataflow.rest.resource.ScheduleInfoResource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TaskScheduleBuilder {
    private final DataFlowOperations dataFlowOperations;
    private String name;
    private Task task;

    public TaskScheduleBuilder(DataFlowOperations dataFlowOperations) {
        this.dataFlowOperations = dataFlowOperations;
    }

    public TaskScheduleBuilder scheduleName(String name) {
        this.name = name;
        return this;
    }

    public TaskScheduleBuilder task(Task task) {
        this.task = task;
        return this;
    }

    public TaskSchedule build() {
        Assert.notNull((Object)this.task, (String)"The schedule task must be set!");
        Assert.isTrue((boolean)StringUtils.hasText((String)this.name), (String)"The schedule name must be set!");
        return new TaskSchedule(this.name, this.task, this.dataFlowOperations.schedulerOperations());
    }

    public Optional<TaskSchedule> findByScheduleName(String scheduleName) {
        if (!this.isScheduled(scheduleName)) {
            return Optional.empty();
        }
        ScheduleInfoResource s = this.dataFlowOperations.schedulerOperations().getSchedule(scheduleName);
        if (s == null) {
            return Optional.empty();
        }
        Optional<Task> task = Task.builder(this.dataFlowOperations).findByName(s.getTaskDefinitionName());
        if (!task.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new TaskSchedule(scheduleName, task.get(), this.dataFlowOperations.schedulerOperations()));
    }

    private boolean isScheduled(String scheduleName) {
        return this.dataFlowOperations.schedulerOperations().list().getContent().stream().anyMatch(sr -> sr.getScheduleName().equals(scheduleName));
    }

    public List<TaskSchedule> list(Task task) {
        return this.dataFlowOperations.schedulerOperations().list(task.getTaskName()).getContent().stream().map(s -> {
            String prefix = s.getScheduleName().replace("-scdf-" + task.getTaskName(), "");
            return new TaskSchedule(prefix, task, this.dataFlowOperations.schedulerOperations());
        }).collect(Collectors.toList());
    }

    public List<TaskSchedule> list() {
        return this.dataFlowOperations.schedulerOperations().list().getContent().stream().map(s -> {
            Task task = Task.builder(this.dataFlowOperations).findByName(s.getTaskDefinitionName()).get();
            String prefix = s.getScheduleName().replace("-scdf-" + task.getTaskName(), "");
            return new TaskSchedule(prefix, task, this.dataFlowOperations.schedulerOperations());
        }).collect(Collectors.toList());
    }
}

