/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.springframework.cloud.dataflow.rest.UpdateStreamRequest;
import org.springframework.cloud.dataflow.rest.client.StreamOperations;
import org.springframework.cloud.dataflow.rest.client.support.VersionUtils;
import org.springframework.cloud.dataflow.rest.resource.StreamAppStatusResource;
import org.springframework.cloud.dataflow.rest.resource.StreamDefinitionResource;
import org.springframework.cloud.dataflow.rest.resource.StreamDeploymentResource;
import org.springframework.cloud.skipper.domain.Deployer;
import org.springframework.cloud.skipper.domain.PackageIdentifier;
import org.springframework.cloud.skipper.domain.Release;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class StreamTemplate
implements StreamOperations {
    public static final String DEFINITIONS_REL = "streams/definitions";
    private static final String DEFINITION_REL = "streams/definitions/definition";
    private static final String DEPLOYMENTS_REL = "streams/deployments";
    private static final String DEPLOYMENT_REL = "streams/deployments/deployment";
    private static final String VALIDATION_REL = "streams/validation";
    private static final String LOGS_REL = "streams/logs/{streamName}";
    private static final String LOGS_APP_REL = "streams/logs/{streamName}/{appName}";
    private static final String VALIDATION_RELATION_VERSION = "1.7.0";
    private final RestTemplate restTemplate;
    private final Link definitionsLink;
    private final Link definitionLink;
    private final Link deploymentsLink;
    private final Link deploymentLink;
    private final Link validationLink;
    private final Link logsLink;
    private final Link logsAppLink;
    private final String dataFlowServerVersion;

    StreamTemplate(RestTemplate restTemplate, RepresentationModel<?> resources, String dataFlowServerVersion) {
        Assert.notNull(resources, (String)"URI CollectionModel can't be null");
        Assert.notNull((Object)resources.getLink(DEFINITIONS_REL), (String)"Definitions relation is required");
        Assert.notNull((Object)resources.getLink(DEFINITION_REL), (String)"Definition relation is required");
        Assert.notNull((Object)resources.getLink(DEPLOYMENTS_REL), (String)"Deployments relation is required");
        Assert.notNull((Object)resources.getLink(DEPLOYMENT_REL), (String)"Deployment relation is required");
        Assert.notNull((Object)resources.getLink(LOGS_REL), (String)"Logs relation is required");
        Assert.notNull((Object)resources.getLink(LOGS_APP_REL), (String)"Logs app relation is required");
        if (VersionUtils.isDataFlowServerVersionGreaterThanOrEqualToRequiredVersion(VersionUtils.getThreePartVersion(dataFlowServerVersion), VALIDATION_RELATION_VERSION)) {
            Assert.notNull((Object)resources.getLink(VALIDATION_REL), (String)"Validation relation for streams is required");
        }
        this.dataFlowServerVersion = dataFlowServerVersion;
        this.restTemplate = restTemplate;
        this.definitionsLink = (Link)resources.getLink(DEFINITIONS_REL).get();
        this.deploymentsLink = (Link)resources.getLink(DEPLOYMENTS_REL).get();
        this.definitionLink = (Link)resources.getLink(DEFINITION_REL).get();
        this.deploymentLink = (Link)resources.getLink(DEPLOYMENT_REL).get();
        this.validationLink = (Link)resources.getLink(VALIDATION_REL).get();
        this.logsLink = (Link)resources.getLink(LOGS_REL).get();
        this.logsAppLink = (Link)resources.getLink(LOGS_APP_REL).get();
    }

    public StreamDefinitionResource.Page list() {
        String uriTemplate = this.definitionsLink.expand(new Object[0]).getHref();
        uriTemplate = uriTemplate + "?size=2000";
        return (StreamDefinitionResource.Page)this.restTemplate.getForObject(uriTemplate, StreamDefinitionResource.Page.class, new Object[0]);
    }

    @Override
    public StreamDeploymentResource info(String name) {
        String uriTemplate = this.deploymentLink.expand(new Object[]{name}).getHref();
        return (StreamDeploymentResource)this.restTemplate.getForObject(uriTemplate, StreamDeploymentResource.class, new Object[0]);
    }

    @Override
    public StreamDefinitionResource createStream(String name, String definition, String description, boolean deploy) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"name", (Object)name);
        values.add((Object)"definition", (Object)definition);
        values.add((Object)"description", (Object)description);
        values.add((Object)"deploy", (Object)Boolean.toString(deploy));
        StreamDefinitionResource stream = (StreamDefinitionResource)this.restTemplate.postForObject(this.definitionsLink.expand(new Object[0]).getHref(), (Object)values, StreamDefinitionResource.class, new Object[0]);
        return stream;
    }

    @Override
    public void deploy(String name, Map<String, String> properties) {
        this.restTemplate.postForObject(this.deploymentLink.expand(new Object[]{name}).getHref(), properties, Object.class, new Object[0]);
    }

    @Override
    public void undeploy(String name) {
        this.restTemplate.delete(this.deploymentLink.expand(new Object[]{name}).getHref(), new Object[0]);
    }

    @Override
    public void undeployAll() {
        this.restTemplate.delete(this.deploymentsLink.getHref(), new Object[0]);
    }

    @Override
    public void destroy(String name) {
        this.restTemplate.delete(this.definitionLink.expand(new Object[]{name}).getHref(), new Object[0]);
    }

    @Override
    public void destroyAll() {
        this.restTemplate.delete(this.definitionsLink.getHref(), new Object[0]);
    }

    @Override
    public void scaleApplicationInstances(String streamName, String appName, Integer count, Map<String, String> properties) {
        String url = String.format("%s/scale/%s/%s/instances/%s", this.deploymentsLink.getHref(), streamName, appName, count);
        this.restTemplate.postForObject(url, properties, Object.class, new Object[0]);
    }

    @Override
    public String streamExecutionLog(String streamName) {
        return (String)this.restTemplate.getForObject(this.logsLink.expand(new Object[]{streamName}).getHref(), String.class, new Object[0]);
    }

    @Override
    public String streamExecutionLog(String streamName, String appName) {
        return (String)this.restTemplate.getForObject(this.logsAppLink.expand(new Object[]{streamName, appName}).getHref(), String.class, new Object[0]);
    }

    @Override
    public void updateStream(String streamName, String releaseName, PackageIdentifier packageIdentifier, Map<String, String> updateProperties, boolean force, List<String> appNames) {
        Assert.hasText((String)streamName, (String)"Stream name cannot be null or empty");
        Assert.notNull((Object)packageIdentifier, (String)"PackageIdentifier cannot be null");
        Assert.hasText((String)packageIdentifier.getPackageName(), (String)"Package Name cannot be null or empty");
        Assert.hasText((String)releaseName, (String)"Release name cannot be null or empty");
        Assert.notNull(updateProperties, (String)"UpdateProperties cannot be null");
        UpdateStreamRequest updateStreamRequest = new UpdateStreamRequest(releaseName, packageIdentifier, updateProperties, force, appNames);
        String url = this.deploymentsLink.getHref() + "/update/" + streamName;
        this.restTemplate.postForObject(url, (Object)updateStreamRequest, Object.class, new Object[0]);
    }

    @Override
    public void rollbackStream(String streamName, int version) {
        Assert.hasText((String)streamName, (String)"Release name cannot be null or empty");
        String url = this.deploymentsLink.getHref() + "/rollback/" + streamName + "/" + version;
        this.restTemplate.postForObject(url, null, Object.class, new Object[0]);
    }

    @Override
    public String getManifest(String streamName, int version) {
        Assert.hasText((String)streamName, (String)"Release name cannot be null or empty");
        String url = String.format("%s/%s/%s/%s", this.deploymentsLink.getHref(), "manifest", streamName, version);
        String manifest = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
        String prunedManifest = manifest.substring(1, manifest.length() - 1);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < prunedManifest.length(); ++i) {
            char testChar = prunedManifest.charAt(i);
            if (testChar == '\\') {
                char nChar;
                if (i == prunedManifest.length() - 1 || (nChar = prunedManifest.charAt(i + 1)) != 'n') continue;
                sb.append("\n");
                ++i;
                continue;
            }
            sb.append(testChar);
        }
        return sb.toString();
    }

    @Override
    public Collection<Release> history(String streamName) {
        Assert.hasText((String)streamName, (String)"Release name cannot be null or empty");
        ParameterizedTypeReference<Collection<Release>> typeReference = new ParameterizedTypeReference<Collection<Release>>(){};
        HashMap parameters = new HashMap();
        String url = String.format("%s/%s/%s", this.deploymentsLink.getHref(), "history", streamName);
        return (Collection)this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, parameters).getBody();
    }

    @Override
    public Collection<Deployer> listPlatforms() {
        ParameterizedTypeReference<Collection<Deployer>> typeReference = new ParameterizedTypeReference<Collection<Deployer>>(){};
        HashMap parameters = new HashMap();
        String url = this.deploymentsLink.getHref() + "/platform/list";
        return (Collection)this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, parameters).getBody();
    }

    @Override
    public StreamDefinitionResource getStreamDefinition(String streamName) {
        String uriTemplate = this.definitionLink.expand(new Object[]{streamName}).getHref();
        return (StreamDefinitionResource)this.restTemplate.getForObject(uriTemplate, StreamDefinitionResource.class, new Object[0]);
    }

    @Override
    public StreamAppStatusResource validateStreamDefinition(String streamDefinitionName) throws OperationNotSupportedException {
        if (this.validationLink == null) {
            throw new OperationNotSupportedException("Stream Validation not supported on Data Flow Server version " + this.dataFlowServerVersion);
        }
        String uriTemplate = this.validationLink.expand(new Object[]{streamDefinitionName}).getHref();
        return (StreamAppStatusResource)this.restTemplate.getForObject(uriTemplate, StreamAppStatusResource.class, new Object[0]);
    }
}

