/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.dataflow.rest.client.SchedulerOperations;
import org.springframework.cloud.dataflow.rest.resource.ScheduleInfoResource;
import org.springframework.cloud.dataflow.rest.util.DeploymentPropertiesUtils;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class SchedulerTemplate
implements SchedulerOperations {
    public static final String SCHEDULES_RELATION = "tasks/schedules";
    private static final String SCHEDULES_INSTANCE_RELATION = "tasks/schedules/instances";
    private final RestTemplate restTemplate;
    private final Link schedulesLink;
    private final Link schedulesInstanceLink;

    SchedulerTemplate(RestTemplate restTemplate, RepresentationModel<?> resources) {
        Assert.notNull(resources, (String)"URI CollectionModel must not be be null");
        Assert.notNull((Object)resources.getLink(SCHEDULES_RELATION), (String)"Schedules relation is required");
        Assert.notNull((Object)resources.getLink(SCHEDULES_INSTANCE_RELATION), (String)"Schedules instance relation is required");
        Assert.notNull((Object)restTemplate, (String)"RestTemplate must not be null");
        this.restTemplate = restTemplate;
        this.schedulesLink = (Link)resources.getLink(SCHEDULES_RELATION).get();
        this.schedulesInstanceLink = (Link)resources.getLink(SCHEDULES_INSTANCE_RELATION).get();
    }

    @Override
    public void schedule(String scheduleName, String taskDefinitionName, Map<String, String> taskProperties, List<String> commandLineArgs, String platform) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)"scheduleName", (Object)scheduleName);
        values.add((Object)"properties", (Object)DeploymentPropertiesUtils.format(taskProperties));
        values.add((Object)"taskDefinitionName", (Object)taskDefinitionName);
        String commandLineArgValue = new String();
        boolean isFirst = true;
        for (String command : commandLineArgs) {
            if (isFirst) {
                isFirst = false;
            } else {
                commandLineArgValue = commandLineArgValue + " ";
            }
            commandLineArgValue = commandLineArgValue + command;
        }
        values.add((Object)"arguments", (Object)commandLineArgValue);
        if (StringUtils.hasText((String)platform)) {
            values.add((Object)"platform", (Object)platform);
        }
        this.restTemplate.postForObject(this.schedulesLink.getHref(), (Object)values, Long.class, new Object[0]);
    }

    @Override
    public void schedule(String scheduleName, String taskDefinitionName, Map<String, String> taskProperties, List<String> commandLineArgs) {
        this.schedule(scheduleName, taskDefinitionName, taskProperties, commandLineArgs, null);
    }

    @Override
    public void unschedule(String scheduleName, String platform) {
        String url = this.schedulesLink.getHref() + "/" + scheduleName;
        if (platform != null) {
            url = url + "?platform=" + platform;
        }
        this.restTemplate.delete(url, new Object[0]);
    }

    @Override
    public void unschedule(String scheduleName) {
        this.unschedule(scheduleName, null);
    }

    @Override
    public PagedModel<ScheduleInfoResource> list(String taskDefinitionName, String platform) {
        String url = this.schedulesInstanceLink.expand(new Object[]{taskDefinitionName}).getHref();
        if (platform != null) {
            url = url + "?platform=" + platform;
        }
        return (PagedModel)this.restTemplate.getForObject(url, ScheduleInfoResource.Page.class, new Object[0]);
    }

    @Override
    public PagedModel<ScheduleInfoResource> list(String taskDefinitionName) {
        return this.list(taskDefinitionName, null);
    }

    @Override
    public PagedModel<ScheduleInfoResource> listByPlatform(String platform) {
        String url = this.schedulesLink.getHref();
        if (platform != null) {
            url = url + "?platform=" + platform;
        }
        return (PagedModel)this.restTemplate.getForObject(url, ScheduleInfoResource.Page.class, new Object[0]);
    }

    @Override
    public PagedModel<ScheduleInfoResource> list() {
        return this.listByPlatform(null);
    }

    @Override
    public ScheduleInfoResource getSchedule(String scheduleName, String platform) {
        String url = this.schedulesLink.getHref() + "/" + scheduleName;
        if (platform != null) {
            url = url + "?platform=" + platform;
        }
        return (ScheduleInfoResource)this.restTemplate.getForObject(url, ScheduleInfoResource.class, new Object[0]);
    }

    @Override
    public ScheduleInfoResource getSchedule(String scheduleName) {
        return this.getSchedule(scheduleName, null);
    }
}

