/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import org.springframework.cloud.dataflow.rest.client.JobOperations;
import org.springframework.cloud.dataflow.rest.resource.JobExecutionResource;
import org.springframework.cloud.dataflow.rest.resource.JobExecutionThinResource;
import org.springframework.cloud.dataflow.rest.resource.JobInstanceResource;
import org.springframework.cloud.dataflow.rest.resource.StepExecutionProgressInfoResource;
import org.springframework.cloud.dataflow.rest.resource.StepExecutionResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class JobTemplate
implements JobOperations {
    private static final String EXECUTIONS_THIN_RELATION = "jobs/thinexecutions";
    private static final String EXECUTIONS_RELATION = "jobs/executions";
    private static final String EXECUTION_RELATION = "jobs/executions/execution";
    private static final String EXECUTION_RELATION_BY_NAME = "jobs/executions/name";
    private static final String EXECUTION_THIN_RELATION_BY_NAME = "jobs/thinexecutions/name";
    private static final String INSTANCE_RELATION = "jobs/instances/instance";
    private static final String INSTANCE_RELATION_BY_NAME = "jobs/instances/name";
    private static final String STEP_EXECUTION_RELATION_BY_ID = "jobs/executions/execution/steps";
    private static final String STEP_EXECUTION_PROGRESS_RELATION_BY_ID = "jobs/executions/execution/steps/step/progress";
    private final RestTemplate restTemplate;
    private final Link executionsLink;
    private final Link thinExecutionsLink;
    private final Link thinExecutionByNameLink;
    private final Link executionLink;
    private final Link executionByNameLink;
    private final Link instanceLink;
    private final Link instanceByNameLink;
    private final Link stepExecutionsLink;
    private final Link stepExecutionProgressLink;

    JobTemplate(RestTemplate restTemplate, RepresentationModel<?> resources) {
        Assert.notNull(resources, (String)"URI CollectionModel must not be be null");
        Assert.notNull((Object)restTemplate, (String)"RestTemplate must not be null");
        Assert.isTrue((boolean)resources.getLink(EXECUTIONS_RELATION).isPresent(), (String)"Executions relation is required");
        Assert.isTrue((boolean)resources.getLink(EXECUTIONS_THIN_RELATION).isPresent(), (String)"Executions thin relation is required");
        Assert.isTrue((boolean)resources.getLink(EXECUTION_THIN_RELATION_BY_NAME).isPresent(), (String)"Executions thin relation is required");
        Assert.isTrue((boolean)resources.getLink(EXECUTION_RELATION).isPresent(), (String)"Execution relation is required");
        Assert.isTrue((boolean)resources.getLink(EXECUTION_RELATION_BY_NAME).isPresent(), (String)"Execution by name relation is required");
        Assert.isTrue((boolean)resources.getLink(INSTANCE_RELATION).isPresent(), (String)"Instance relation is required");
        Assert.isTrue((boolean)resources.getLink(INSTANCE_RELATION_BY_NAME).isPresent(), (String)"Instance by name relation is required");
        Assert.isTrue((boolean)resources.getLink(STEP_EXECUTION_RELATION_BY_ID).isPresent(), (String)"Step Execution by id relation is required");
        Assert.isTrue((boolean)resources.getLink(STEP_EXECUTION_PROGRESS_RELATION_BY_ID).isPresent(), (String)"Step Execution Progress by id relation is required");
        Assert.isTrue((boolean)resources.getLink(STEP_EXECUTION_PROGRESS_RELATION_BY_ID).isPresent(), (String)"Step Execution View by id relation is required");
        this.restTemplate = restTemplate;
        this.executionsLink = (Link)resources.getLink(EXECUTION_RELATION).get();
        this.thinExecutionsLink = (Link)resources.getLink(EXECUTIONS_THIN_RELATION).get();
        this.executionLink = (Link)resources.getLink(EXECUTION_RELATION).get();
        this.executionByNameLink = (Link)resources.getLink(EXECUTION_RELATION_BY_NAME).get();
        this.thinExecutionByNameLink = (Link)resources.getLink(EXECUTION_THIN_RELATION_BY_NAME).get();
        this.instanceLink = (Link)resources.getLink(INSTANCE_RELATION).get();
        this.instanceByNameLink = (Link)resources.getLink(INSTANCE_RELATION_BY_NAME).get();
        this.stepExecutionsLink = (Link)resources.getLink(STEP_EXECUTION_RELATION_BY_ID).get();
        this.stepExecutionProgressLink = (Link)resources.getLink(STEP_EXECUTION_PROGRESS_RELATION_BY_ID).get();
    }

    @Override
    public PagedModel<JobExecutionResource> executionList() {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.executionsLink.getHref()).queryParam("size", new Object[]{"2000"});
        return (PagedModel)this.restTemplate.getForObject(builder.toUriString(), JobExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public void executionRestart(long id, String schemaTarget) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.executionLink.expand(new Object[]{id}).getHref()).queryParam("restart", new Object[]{"true"});
        if (StringUtils.hasText((String)schemaTarget)) {
            builder.queryParam("schemaTarget", new Object[]{schemaTarget});
        }
        this.restTemplate.put(builder.toUriString(), null, new Object[0]);
    }

    @Override
    public PagedModel<JobExecutionThinResource> executionThinList() {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.thinExecutionsLink.getHref()).queryParam("size", new Object[]{"2000"});
        return (PagedModel)this.restTemplate.getForObject(builder.toUriString(), JobExecutionThinResource.Page.class, new Object[0]);
    }

    @Override
    public PagedModel<JobInstanceResource> instanceList(String jobName) {
        return (PagedModel)this.restTemplate.getForObject(this.instanceByNameLink.expand(new Object[]{jobName}).getHref(), JobInstanceResource.Page.class, new Object[0]);
    }

    @Override
    public PagedModel<JobExecutionThinResource> executionThinListByJobName(String jobName) {
        return (PagedModel)this.restTemplate.getForObject(this.thinExecutionByNameLink.expand(new Object[]{jobName}).getHref(), JobExecutionThinResource.Page.class, new Object[0]);
    }

    @Override
    public PagedModel<JobExecutionResource> executionListByJobName(String jobName) {
        return (PagedModel)this.restTemplate.getForObject(this.executionByNameLink.expand(new Object[]{jobName}).getHref(), JobExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public JobExecutionResource jobExecution(long id, String schemaTarget) {
        String url = this.executionLink.expand(new Object[]{id}).getHref();
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)url);
        if (StringUtils.hasText((String)schemaTarget)) {
            builder.queryParam("schemaTarget", new Object[]{schemaTarget});
        }
        return (JobExecutionResource)this.restTemplate.getForObject(builder.toUriString(), JobExecutionResource.class, new Object[0]);
    }

    @Override
    public JobInstanceResource jobInstance(long id, String schemaTarget) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.instanceLink.expand(new Object[]{id}).getHref());
        if (StringUtils.hasText((String)schemaTarget)) {
            builder.queryParam("schemaTarget", new Object[]{schemaTarget});
        }
        return (JobInstanceResource)this.restTemplate.getForObject(builder.toUriString(), JobInstanceResource.class, new Object[0]);
    }

    @Override
    public PagedModel<StepExecutionResource> stepExecutionList(long jobExecutionId, String schemaTarget) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.stepExecutionsLink.expand(new Object[]{jobExecutionId}).getHref());
        if (StringUtils.hasText((String)schemaTarget)) {
            builder.queryParam("schemaTarget", new Object[]{schemaTarget});
        }
        return (PagedModel)this.restTemplate.getForObject(builder.toUriString(), StepExecutionResource.Page.class, new Object[0]);
    }

    @Override
    public StepExecutionProgressInfoResource stepExecutionProgress(long jobExecutionId, long stepExecutionId, String schemaTarget) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.stepExecutionProgressLink.expand(new Object[]{jobExecutionId, stepExecutionId}).getHref());
        if (StringUtils.hasText((String)schemaTarget)) {
            builder.queryParam("schemaTarget", new Object[]{schemaTarget});
        }
        return (StepExecutionProgressInfoResource)this.restTemplate.getForObject(builder.toUriString(), StepExecutionProgressInfoResource.class, new Object[0]);
    }
}

