/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.dataflow.rest.client.AboutOperations;
import org.springframework.cloud.dataflow.rest.client.AboutTemplate;
import org.springframework.cloud.dataflow.rest.client.AppRegistryOperations;
import org.springframework.cloud.dataflow.rest.client.AppRegistryTemplate;
import org.springframework.cloud.dataflow.rest.client.CompletionOperations;
import org.springframework.cloud.dataflow.rest.client.CompletionTemplate;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.DataFlowServerException;
import org.springframework.cloud.dataflow.rest.client.JobOperations;
import org.springframework.cloud.dataflow.rest.client.JobTemplate;
import org.springframework.cloud.dataflow.rest.client.RuntimeOperations;
import org.springframework.cloud.dataflow.rest.client.RuntimeTemplate;
import org.springframework.cloud.dataflow.rest.client.SchedulerOperations;
import org.springframework.cloud.dataflow.rest.client.SchedulerTemplate;
import org.springframework.cloud.dataflow.rest.client.StreamOperations;
import org.springframework.cloud.dataflow.rest.client.StreamTemplate;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.dataflow.rest.client.TaskTemplate;
import org.springframework.cloud.dataflow.rest.client.VndErrorResponseErrorHandler;
import org.springframework.cloud.dataflow.rest.resource.RootResource;
import org.springframework.cloud.dataflow.rest.resource.about.AboutResource;
import org.springframework.cloud.dataflow.rest.support.jackson.Jackson2DataflowModule;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class DataFlowTemplate
implements DataFlowOperations {
    protected final RestTemplate restTemplate;
    protected final Map<String, UriTemplate> resources = new HashMap<String, UriTemplate>();
    private final StreamOperations streamOperations;
    private final TaskOperations taskOperations;
    private final JobOperations jobOperations;
    private final AppRegistryOperations appRegistryOperations;
    private final CompletionOperations completionOperations;
    private final RuntimeOperations runtimeOperations;
    private final AboutOperations aboutOperations;
    private final SchedulerOperations schedulerOperations;

    public DataFlowTemplate(URI baseURI, ObjectMapper mapper) {
        this(baseURI, DataFlowTemplate.getDefaultDataflowRestTemplate(), mapper);
    }

    public DataFlowTemplate(URI baseURI, RestTemplate restTemplate, ObjectMapper mapper) {
        Assert.notNull((Object)baseURI, (String)"The provided baseURI must not be null.");
        Assert.notNull((Object)restTemplate, (String)"The provided restTemplate must not be null.");
        this.restTemplate = DataFlowTemplate.prepareRestTemplate(restTemplate);
        RootResource resourceSupport = (RootResource)restTemplate.getForObject(baseURI, RootResource.class);
        if (resourceSupport != null) {
            if (resourceSupport.getApiRevision() == null) {
                throw new IllegalStateException("Incompatible version of Data Flow server detected.\nFollow instructions in the documentation for the version of the server you are using to download a compatible version of the shell.\nDocumentation can be accessed at https://cloud.spring.io/spring-cloud-dataflow/");
            }
            String serverRevision = resourceSupport.getApiRevision().toString();
            if (!String.valueOf(14).equals(serverRevision)) {
                String downloadURL = this.getLink((RepresentationModel<?>)resourceSupport, "dashboard").getHref() + "#about";
                throw new IllegalStateException(String.format("Incompatible version of Data Flow server detected.\nTrying to use shell which supports revision %s, while server revision is %s. Both revisions should be aligned.\nFollow instructions at %s to download a compatible version of the shell.", 14, serverRevision, downloadURL));
            }
            this.aboutOperations = new AboutTemplate(restTemplate, (Link)resourceSupport.getLink("about").get());
            if (resourceSupport.hasLink("streams/definitions")) {
                this.streamOperations = new StreamTemplate(restTemplate, (RepresentationModel<?>)resourceSupport, this.getVersion());
                this.runtimeOperations = new RuntimeTemplate(restTemplate, (RepresentationModel<?>)resourceSupport);
            } else {
                this.streamOperations = null;
                this.runtimeOperations = null;
            }
            if (resourceSupport.hasLink("tasks/definitions")) {
                if (mapper == null) {
                    mapper = new ObjectMapper();
                    mapper.registerModule((Module)new Jdk8Module());
                    mapper.registerModule((Module)new Jackson2HalModule());
                    mapper.registerModule((Module)new JavaTimeModule());
                    mapper.registerModule((Module)new Jackson2DataflowModule());
                }
                this.taskOperations = new TaskTemplate(restTemplate, (RepresentationModel<?>)resourceSupport, this.getVersion());
                this.jobOperations = new JobTemplate(restTemplate, (RepresentationModel<?>)resourceSupport);
                this.schedulerOperations = resourceSupport.hasLink("tasks/schedules") ? new SchedulerTemplate(restTemplate, (RepresentationModel<?>)resourceSupport) : null;
            } else {
                this.taskOperations = null;
                this.jobOperations = null;
                this.schedulerOperations = null;
            }
            this.appRegistryOperations = new AppRegistryTemplate(restTemplate, (RepresentationModel<?>)resourceSupport);
            this.completionOperations = new CompletionTemplate(restTemplate, (Link)resourceSupport.getLink("completions/stream").get(), (Link)resourceSupport.getLink("completions/task").get());
        } else {
            this.aboutOperations = null;
            this.streamOperations = null;
            this.runtimeOperations = null;
            this.taskOperations = null;
            this.jobOperations = null;
            this.appRegistryOperations = null;
            this.completionOperations = null;
            this.schedulerOperations = null;
        }
    }

    private String getVersion() {
        String version = "";
        AboutResource aboutResource = this.aboutOperations.get();
        if (aboutResource != null) {
            version = aboutResource.getVersionInfo().getCore().getVersion();
        }
        return version;
    }

    public static RestTemplate prepareRestTemplate(RestTemplate restTemplate) {
        if (restTemplate == null) {
            restTemplate = new RestTemplate();
        }
        restTemplate.setErrorHandler((ResponseErrorHandler)new VndErrorResponseErrorHandler(restTemplate.getMessageConverters()));
        boolean containsMappingJackson2HttpMessageConverter = false;
        for (HttpMessageConverter converter : restTemplate.getMessageConverters()) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            containsMappingJackson2HttpMessageConverter = true;
            MappingJackson2HttpMessageConverter jacksonConverter = (MappingJackson2HttpMessageConverter)converter;
            DataFlowTemplate.prepareObjectMapper(jacksonConverter.getObjectMapper());
        }
        if (!containsMappingJackson2HttpMessageConverter) {
            throw new IllegalArgumentException("The RestTemplate does not contain a required MappingJackson2HttpMessageConverter.");
        }
        return restTemplate;
    }

    public static ObjectMapper prepareObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"The objectMapper must not be null.");
        return objectMapper.registerModules(new Module[]{new Jackson2HalModule(), new Jackson2DataflowModule()});
    }

    public static RestTemplate getDefaultDataflowRestTemplate() {
        return DataFlowTemplate.prepareRestTemplate(null);
    }

    public Link getLink(RepresentationModel<?> resourceSupport, String rel) {
        return (Link)resourceSupport.getLink(rel).orElseThrow(() -> new DataFlowServerException("Server did not return a link for '" + rel + "', links: '" + resourceSupport + "'"));
    }

    @Override
    public StreamOperations streamOperations() {
        return this.streamOperations;
    }

    @Override
    public TaskOperations taskOperations() {
        return this.taskOperations;
    }

    @Override
    public JobOperations jobOperations() {
        return this.jobOperations;
    }

    @Override
    public AppRegistryOperations appRegistryOperations() {
        return this.appRegistryOperations;
    }

    @Override
    public CompletionOperations completionOperations() {
        return this.completionOperations;
    }

    @Override
    public RuntimeOperations runtimeOperations() {
        return this.runtimeOperations;
    }

    @Override
    public AboutOperations aboutOperation() {
        return this.aboutOperations;
    }

    @Override
    public SchedulerOperations schedulerOperations() {
        return this.schedulerOperations;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

