/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.springframework.cloud.contract.wiremock.restdocs.JsonPathValue;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;

public abstract class WireMockVerifyHelper<T, S extends WireMockVerifyHelper<T, S>> {
    private Map<String, JsonPath> jsonPaths = new LinkedHashMap<String, JsonPath>();
    private MediaType contentType;
    private MappingBuilder builder;

    public void configure(T result) {
        Map<String, Object> configuration = this.getConfiguration(result);
        byte[] requestBodyContent = this.getRequestBodyContent(result);
        if (requestBodyContent != null) {
            String actual = new String(requestBodyContent, Charset.forName("UTF-8"));
            for (JsonPath jsonPath : this.jsonPaths.values()) {
                new JsonPathValue(jsonPath, actual).assertHasValue(Object.class, "an object");
            }
        }
        configuration.put("contract.jsonPaths", this.jsonPaths.keySet());
        if (this.contentType != null) {
            configuration.put("contract.contentType", this.contentType);
            MediaType resultType = this.getContentType(result);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)resultType).isNotNull()).as("no content type", new Object[0]);
            Assertions.assertThat((boolean)this.contentType.includes(resultType)).isTrue().as("content type did not match", new Object[0]);
        }
        if (this.builder != null) {
            this.builder.willReturn(this.getResponseDefinition(result));
            StubMapping stubMapping = this.builder.build();
            Request request = this.getWireMockRequest(result);
            MatchResult match = stubMapping.getRequest().match(request);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)match.isExactMatch()).as("wiremock did not match request", new Object[0])).isTrue();
            configuration.put("contract.stubMapping", stubMapping);
        }
    }

    protected abstract Request getWireMockRequest(T var1);

    protected abstract MediaType getContentType(T var1);

    protected abstract byte[] getRequestBodyContent(T var1);

    protected abstract ResponseDefinitionBuilder getResponseDefinition(T var1);

    protected abstract Map<String, Object> getConfiguration(T var1);

    public S wiremock(MappingBuilder builder) {
        this.builder = builder;
        return (S)this;
    }

    public S jsonPath(String expression, Object ... args) {
        this.compile(expression, args);
        return (S)this;
    }

    public S contentType(MediaType contentType) {
        this.contentType = contentType;
        return (S)this;
    }

    private void compile(String expression, Object ... args) {
        Assert.hasText((String)(expression == null ? null : expression), (String)"expression must not be null or empty");
        expression = String.format(expression, args);
        this.jsonPaths.put(expression, JsonPath.compile((String)expression, (Predicate[])new Predicate[0]));
    }
}

