/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import java.lang.reflect.Field;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
public class WireMockRestTemplateConfiguration {
    @Bean
    @ConditionalOnClass(value={SSLContextBuilder.class})
    @ConditionalOnProperty(value={"wiremock.rest-template-ssl-enabled"}, matchIfMissing=true)
    public RestTemplateCustomizer wiremockRestTemplateCustomizer() {
        return new RestTemplateCustomizer(){

            public void customize(RestTemplate restTemplate) {
                Field requestFactoryField;
                ClientHttpRequestFactory clientHttpRequestFactory = restTemplate.getRequestFactory();
                if (clientHttpRequestFactory instanceof HttpComponentsClientHttpRequestFactory) {
                    HttpComponentsClientHttpRequestFactory factory = (HttpComponentsClientHttpRequestFactory)clientHttpRequestFactory;
                    factory.setHttpClient(this.createSslHttpClient());
                } else if (restTemplate.getRequestFactory() instanceof InterceptingClientHttpRequestFactory && (requestFactoryField = ReflectionUtils.findField(RestTemplate.class, (String)"requestFactory")) != null) {
                    requestFactoryField.setAccessible(true);
                    ClientHttpRequestFactory requestFactory = (ClientHttpRequestFactory)ReflectionUtils.getField((Field)requestFactoryField, (Object)restTemplate);
                    if (requestFactory instanceof HttpComponentsClientHttpRequestFactory) {
                        HttpComponentsClientHttpRequestFactory factory = (HttpComponentsClientHttpRequestFactory)requestFactory;
                        factory.setHttpClient(this.createSslHttpClient());
                    }
                }
            }

            private HttpClient createSslHttpClient() {
                try {
                    SSLConnectionSocketFactoryBuilder sslConnectionSocketFactoryBuilder = SSLConnectionSocketFactoryBuilder.create();
                    sslConnectionSocketFactoryBuilder.setSslContext(new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)TrustSelfSignedStrategy.INSTANCE).build()).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactoryBuilder.build()).build();
                    return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Unable to create SSL HttpClient", ex);
                }
            }
        };
    }
}

