/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.template;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.WireMockHelpers;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.ContractTemplate;
import org.springframework.cloud.contract.spec.internal.CompositeContractTemplate;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.TestSideRequestTemplateModel;
import org.springframework.cloud.contract.verifier.builder.handlebars.HandlebarsJsonPathHelper;
import org.springframework.cloud.contract.verifier.template.TemplateProcessor;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Template;

public class HandlebarsTemplateProcessor
implements TemplateProcessor,
ContractTemplate {
    private static final Pattern ESCAPED_LEGACY_JSON_PATH_PATTERN = Pattern.compile("^.*\\{\\{\\{jsonpath this '(.*)'}}}.*$");
    private static final Pattern ESCAPED_JSON_PATH_PATTERN = Pattern.compile("^.*\\{\\{\\{jsonPath request.body '(.*)'}}}.*$");
    private static final Pattern LEGACY_JSON_PATH_PATTERN = Pattern.compile("^.*\\{\\{jsonpath this '(.*)'}}.*$");
    private static final Pattern JSON_PATH_PATTERN = Pattern.compile("^.*\\{\\{jsonPath request.body '(.*)'}}.*$");
    private static final List<Pattern> PATTERNS = Arrays.asList(ESCAPED_LEGACY_JSON_PATH_PATTERN, ESCAPED_JSON_PATH_PATTERN, LEGACY_JSON_PATH_PATTERN, JSON_PATH_PATTERN);
    private static final String LEGACY_JSON_PATH_TEMPLATE_NAME = "jsonpath";
    private static final String JSON_PATH_TEMPLATE_NAME = WireMockHelpers.jsonPath.name();
    private final ContractTemplate contractTemplate = new CompositeContractTemplate();

    @Override
    public String transform(Request request, String testContents) {
        TestSideRequestTemplateModel templateModel = TestSideRequestTemplateModel.from(request);
        Map<String, TestSideRequestTemplateModel> model = Collections.singletonMap("request", templateModel);
        Template bodyTemplate = this.uncheckedCompileTemplate(testContents);
        return this.templatedResponseBody(model, bodyTemplate);
    }

    @Override
    public boolean containsTemplateEntry(String line) {
        return line.contains(this.contractTemplate.openingTemplate()) && line.contains(this.contractTemplate.closingTemplate()) || line.contains(this.contractTemplate.escapedOpeningTemplate()) && line.contains(this.contractTemplate.escapedClosingTemplate());
    }

    @Override
    public boolean containsJsonPathTemplateEntry(String line) {
        return line.contains(this.openingTemplate() + LEGACY_JSON_PATH_TEMPLATE_NAME) || line.contains(this.openingTemplate() + JSON_PATH_TEMPLATE_NAME) || line.contains(this.escapedOpeningTemplate() + LEGACY_JSON_PATH_TEMPLATE_NAME) || line.contains(this.escapedOpeningTemplate() + JSON_PATH_TEMPLATE_NAME);
    }

    @Override
    public String jsonPathFromTemplateEntry(String line) {
        if (!this.containsJsonPathTemplateEntry(line)) {
            return "";
        }
        for (Pattern pattern : PATTERNS) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return "";
    }

    private String templatedResponseBody(Map<String, TestSideRequestTemplateModel> model, Template bodyTemplate) {
        return this.uncheckedApplyTemplate(bodyTemplate, model);
    }

    private String uncheckedApplyTemplate(Template template, Object context) {
        try {
            return template.apply(context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Template uncheckedCompileTemplate(String content) {
        try {
            Handlebars handlebars = new Handlebars();
            handlebars.registerHelper(LEGACY_JSON_PATH_TEMPLATE_NAME, (Helper)new HandlebarsJsonPathHelper());
            handlebars.registerHelper(WireMockHelpers.jsonPath.name(), (Helper)new HandlebarsJsonPathHelper());
            Arrays.stream(WireMockHelpers.values()).filter(helper -> !helper.equals((Object)WireMockHelpers.jsonPath)).forEach(helper -> handlebars.registerHelper(helper.name(), (Helper)helper));
            return handlebars.compileInline(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean startsWithTemplate(String text) {
        return this.contractTemplate.startsWithTemplate(text);
    }

    public boolean startsWithEscapedTemplate(String text) {
        return this.contractTemplate.startsWithEscapedTemplate(text);
    }

    public String openingTemplate() {
        return this.contractTemplate.openingTemplate();
    }

    public String closingTemplate() {
        return this.contractTemplate.closingTemplate();
    }

    public String escapedOpeningTemplate() {
        return this.contractTemplate.escapedOpeningTemplate();
    }

    public String escapedClosingTemplate() {
        return this.contractTemplate.escapedClosingTemplate();
    }

    public String url() {
        return this.contractTemplate.url();
    }

    public String query(String key) {
        return this.contractTemplate.query(key);
    }

    public String query(String key, int index) {
        return this.contractTemplate.query(key, index);
    }

    public String path() {
        return this.contractTemplate.path();
    }

    public String path(int index) {
        return this.contractTemplate.path(index);
    }

    public String header(String key) {
        return this.contractTemplate.header(key);
    }

    public String header(String key, int index) {
        return this.contractTemplate.header(key, index);
    }

    public String cookie(String key) {
        return this.contractTemplate.cookie(key);
    }

    public String body() {
        return this.contractTemplate.body();
    }

    public String body(String jsonPath) {
        return this.contractTemplate.body(jsonPath);
    }

    public String escapedUrl() {
        return this.contractTemplate.escapedUrl();
    }

    public String escapedQuery(String key) {
        return this.contractTemplate.escapedQuery(key);
    }

    public String escapedQuery(String key, int index) {
        return this.contractTemplate.escapedQuery(key, index);
    }

    public String escapedPath() {
        return this.contractTemplate.escapedPath();
    }

    public String escapedPath(int index) {
        return this.contractTemplate.escapedPath(index);
    }

    public String escapedHeader(String key) {
        return this.contractTemplate.escapedHeader(key);
    }

    public String escapedHeader(String key, int index) {
        return this.contractTemplate.escapedHeader(key, index);
    }

    public String escapedCookie(String key) {
        return this.contractTemplate.escapedCookie(key);
    }

    public String escapedBody() {
        return this.contractTemplate.escapedBody();
    }

    public String escapedBody(String jsonPath) {
        return this.contractTemplate.escapedBody(jsonPath);
    }
}

