/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.JUnitMethodMetadata;
import org.springframework.cloud.contract.verifier.builder.SingleMethodBuilder;
import org.springframework.cloud.contract.verifier.builder.SpockMethodMetadata;

class MethodMetadataBuilder {
    private final SingleMethodBuilder singleMethodBuilder;
    private final BlockBuilder builder;
    private final GeneratedClassMetaData metaData;

    MethodMetadataBuilder(SingleMethodBuilder singleMethodBuilder) {
        this.singleMethodBuilder = singleMethodBuilder;
        this.builder = singleMethodBuilder.blockBuilder;
        this.metaData = singleMethodBuilder.generatedClassMetaData;
    }

    MethodMetadataBuilder jUnit() {
        this.singleMethodBuilder.methodMetadata(new JUnitMethodMetadata(this.builder, this.metaData));
        return this;
    }

    MethodMetadataBuilder spock() {
        this.singleMethodBuilder.methodMetadata(new SpockMethodMetadata(this.builder, this.metaData));
        return this;
    }

    SingleMethodBuilder build() {
        return this.singleMethodBuilder;
    }
}

