/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery.configclient;

import com.ecwid.consul.v1.ConsulClient;
import java.util.Collections;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.consul.ConsulAutoConfiguration;
import org.springframework.cloud.consul.ConsulProperties;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.util.ClassUtils;

public class ConsulConfigServerBootstrapper
implements BootstrapRegistryInitializer {
    public void initialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null) || ClassUtils.isPresent((String)"org.springframework.cloud.bootstrap.marker.Marker", null)) {
            return;
        }
        registry.registerIfAbsent(ConsulProperties.class, context -> {
            Binder binder = (Binder)context.get(Binder.class);
            if (!this.isDiscoveryEnabled(binder)) {
                return null;
            }
            return (ConsulProperties)binder.bind("spring.cloud.consul", Bindable.of(ConsulProperties.class), this.getBindHandler(context)).orElseGet(ConsulProperties::new);
        });
        registry.registerIfAbsent(ConsulClient.class, context -> {
            if (!this.isDiscoveryEnabled((Binder)context.get(Binder.class))) {
                return null;
            }
            ConsulProperties consulProperties = (ConsulProperties)context.get(ConsulProperties.class);
            return ConsulAutoConfiguration.createConsulClient((ConsulProperties)consulProperties);
        });
        registry.registerIfAbsent(ConsulDiscoveryClient.class, context -> {
            Binder binder = (Binder)context.get(Binder.class);
            if (!this.isDiscoveryEnabled(binder)) {
                return null;
            }
            ConsulClient consulClient = (ConsulClient)context.get(ConsulClient.class);
            ConsulDiscoveryProperties properties = (ConsulDiscoveryProperties)binder.bind("spring.cloud.consul.discovery", Bindable.of(ConsulDiscoveryProperties.class), this.getBindHandler(context)).orElseGet(() -> new ConsulDiscoveryProperties(new InetUtils(new InetUtilsProperties())));
            return new ConsulDiscoveryClient(consulClient, properties);
        });
        registry.addCloseListener(event -> {
            if (!this.isDiscoveryEnabled((Binder)event.getBootstrapContext().get(Binder.class))) {
                return;
            }
            ConsulDiscoveryClient discoveryClient = (ConsulDiscoveryClient)event.getBootstrapContext().get(ConsulDiscoveryClient.class);
            if (discoveryClient != null) {
                event.getApplicationContext().getBeanFactory().registerSingleton("consulDiscoveryClient", (Object)discoveryClient);
            }
        });
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, context -> {
            if (!this.isDiscoveryEnabled((Binder)context.get(Binder.class))) {
                return id -> Collections.emptyList();
            }
            ConsulDiscoveryClient discoveryClient = (ConsulDiscoveryClient)context.get(ConsulDiscoveryClient.class);
            return discoveryClient::getInstances;
        });
    }

    private BindHandler getBindHandler(BootstrapContext context) {
        return (BindHandler)context.getOrElse(BindHandler.class, null);
    }

    private boolean isDiscoveryEnabled(Binder binder) {
        return (Boolean)binder.bind("spring.cloud.config.discovery.enabled", Boolean.class).orElse((Object)false) != false && (Boolean)binder.bind("spring.cloud.consul.discovery.enabled", Boolean.class).orElse((Object)true) != false && (Boolean)binder.bind("spring.cloud.discovery.enabled", Boolean.class).orElse((Object)true) != false;
    }
}

