/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

abstract class S3ConfigFile {
    protected static final Log LOG = LogFactory.getLog(S3ConfigFile.class);
    protected String application;
    protected String label;
    protected String profile;
    protected String bucketName;
    protected S3Client s3Client;
    protected Properties properties;
    private String version;
    private boolean shouldIncludeWithEmptyProperties = true;
    private final boolean useApplicationAsDirectory;

    protected S3ConfigFile(String application, String profile, String label, String bucketName, boolean useApplicationAsDirectory, S3Client s3Client) {
        this.application = application;
        this.profile = profile;
        this.label = label;
        this.bucketName = bucketName;
        this.s3Client = s3Client;
        this.useApplicationAsDirectory = useApplicationAsDirectory;
    }

    String getVersion() {
        return this.version;
    }

    abstract Properties read();

    boolean isShouldIncludeWithEmptyProperties() {
        return this.shouldIncludeWithEmptyProperties;
    }

    void setShouldIncludeWithEmptyProperties(boolean shouldIncludeWithEmptyProperties) {
        this.shouldIncludeWithEmptyProperties = shouldIncludeWithEmptyProperties;
    }

    public String getName() {
        return this.createPropertySourceName(this.application, this.profile);
    }

    protected ResponseInputStream<GetObjectResponse> getObject() throws Exception {
        assert (this.getExtensions() != null && !this.getExtensions().isEmpty());
        List<String> extensions = this.getExtensions();
        for (int i = 0; i < extensions.size(); ++i) {
            String key = this.buildObjectKeyPrefix() + "." + extensions.get(i);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting object with key " + key));
            }
            try {
                ResponseInputStream inputStream = this.s3Client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(key).build());
                this.version = ((GetObjectResponse)inputStream.response()).versionId();
                return inputStream;
            }
            catch (Exception e) {
                if (i < extensions.size() - 1) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Did not find " + key + ".  Trying next extension"), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        return null;
    }

    protected abstract List<String> getExtensions();

    protected String buildObjectKeyPrefix() {
        return this.buildObjectKeyPrefix(true);
    }

    String buildObjectKeyPrefix(boolean includeProfile) {
        StringBuilder objectKeyPrefix = new StringBuilder();
        if (!ObjectUtils.isEmpty((Object)this.label)) {
            objectKeyPrefix.append(this.label).append("/");
        }
        objectKeyPrefix.append(this.application);
        if (this.useApplicationAsDirectory) {
            objectKeyPrefix.append("/").append("application");
        }
        if (!ObjectUtils.isEmpty((Object)this.profile) && includeProfile) {
            objectKeyPrefix.append("-").append(this.profile);
        }
        return objectKeyPrefix.toString();
    }

    private String createPropertySourceName(String app, String profile) {
        StringBuilder propertySourceName = new StringBuilder().append("s3:").append(app);
        if (this.useApplicationAsDirectory) {
            propertySourceName.append("/").append("application");
        }
        if (profile != null) {
            propertySourceName.append("-").append(profile);
        }
        return propertySourceName.toString();
    }
}

